/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.UOE;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQuery;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanResultValue;
import org.apache.hive.druid.org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.filter.Filters;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class ScanQueryEngine {
    private static final String LEGACY_TIMESTAMP_KEY = "timestamp";

    public Sequence<ScanResultValue> process(final ScanQuery query, Segment segment, final ResponseContext responseContext) {
        long count;
        final boolean legacy = Preconditions.checkNotNull(query.isLegacy(), "WTF?! Expected non-null legacy");
        Object numScannedRows = responseContext.get(ResponseContext.Key.NUM_SCANNED_ROWS);
        if (numScannedRows != null && (count = ((Long)numScannedRows).longValue()) >= query.getScanRowsLimit() && query.getOrder().equals((Object)ScanQuery.Order.NONE)) {
            return Sequences.empty();
        }
        final boolean hasTimeout = QueryContexts.hasTimeout(query);
        final long timeoutAt = (Long)responseContext.get(ResponseContext.Key.TIMEOUT_AT);
        final long start = System.currentTimeMillis();
        StorageAdapter adapter = segment.asStorageAdapter();
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        final ArrayList<String> allColumns = new ArrayList<String>();
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            if (legacy && !query.getColumns().contains(LEGACY_TIMESTAMP_KEY)) {
                allColumns.add(LEGACY_TIMESTAMP_KEY);
            }
            allColumns.addAll(query.getColumns());
        } else {
            LinkedHashSet<String> availableColumns = Sets.newLinkedHashSet(Iterables.concat(Collections.singleton(legacy ? LEGACY_TIMESTAMP_KEY : "__time"), Iterables.transform(Arrays.asList(query.getVirtualColumns().getVirtualColumns()), VirtualColumn::getOutputName), adapter.getAvailableDimensions(), adapter.getAvailableMetrics()));
            allColumns.addAll(availableColumns);
            if (legacy) {
                allColumns.remove("__time");
            }
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument(intervals.size() == 1, "Can only handle a single interval, got[%s]", intervals);
        final SegmentId segmentId = segment.getId();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()));
        responseContext.add(ResponseContext.Key.NUM_SCANNED_ROWS, 0L);
        final long limit = this.calculateRemainingScanRowsLimit(query, responseContext);
        return Sequences.concat(adapter.makeCursors(filter, intervals.get(0), query.getVirtualColumns(), Granularities.ALL, query.getOrder().equals((Object)ScanQuery.Order.DESCENDING) || query.getOrder().equals((Object)ScanQuery.Order.NONE) && query.isDescending(), null).map(cursor -> new BaseSequence<ScanResultValue, Iterator<ScanResultValue>>(new BaseSequence.IteratorMaker<ScanResultValue, Iterator<ScanResultValue>>(){

            @Override
            public Iterator<ScanResultValue> make() {
                final ArrayList<ColumnValueSelector> columnSelectors = new ArrayList<ColumnValueSelector>(allColumns.size());
                for (String column : allColumns) {
                    ColumnValueSelector selector = legacy && ScanQueryEngine.LEGACY_TIMESTAMP_KEY.equals(column) ? cursor.getColumnSelectorFactory().makeColumnValueSelector("__time") : cursor.getColumnSelectorFactory().makeColumnValueSelector(column);
                    columnSelectors.add(selector);
                }
                final int batchSize = query.getBatchSize();
                return new Iterator<ScanResultValue>(){
                    private long offset = 0L;

                    @Override
                    public boolean hasNext() {
                        return !cursor.isDone() && this.offset < limit;
                    }

                    @Override
                    public ScanResultValue next() {
                        List<Object> events;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (hasTimeout && System.currentTimeMillis() >= timeoutAt) {
                            throw new QueryInterruptedException(new TimeoutException());
                        }
                        long lastOffset = this.offset;
                        ScanQuery.ResultFormat resultFormat = query.getResultFormat();
                        if (ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST.equals((Object)resultFormat)) {
                            events = this.rowsToCompactedList();
                        } else if (ScanQuery.ResultFormat.RESULT_FORMAT_LIST.equals((Object)resultFormat)) {
                            events = this.rowsToList();
                        } else {
                            throw new UOE("resultFormat[%s] is not supported", resultFormat.toString());
                        }
                        responseContext.add(ResponseContext.Key.NUM_SCANNED_ROWS, this.offset - lastOffset);
                        if (hasTimeout) {
                            responseContext.put(ResponseContext.Key.TIMEOUT_AT, timeoutAt - (System.currentTimeMillis() - start));
                        }
                        return new ScanResultValue(segmentId.toString(), allColumns, events);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private List<Object> rowsToCompactedList() {
                        ArrayList<Object> events = new ArrayList<Object>(batchSize);
                        long iterLimit = Math.min(limit, this.offset + (long)batchSize);
                        while (!cursor.isDone() && this.offset < iterLimit) {
                            ArrayList<Object> theEvent = new ArrayList<Object>(allColumns.size());
                            for (int j = 0; j < allColumns.size(); ++j) {
                                theEvent.add(this.getColumnValue(j));
                            }
                            events.add(theEvent);
                            cursor.advance();
                            ++this.offset;
                        }
                        return events;
                    }

                    private List<Map<String, Object>> rowsToList() {
                        ArrayList<Map<String, Object>> events = Lists.newArrayListWithCapacity(batchSize);
                        long iterLimit = Math.min(limit, this.offset + (long)batchSize);
                        while (!cursor.isDone() && this.offset < iterLimit) {
                            LinkedHashMap theEvent = new LinkedHashMap();
                            for (int j = 0; j < allColumns.size(); ++j) {
                                theEvent.put(allColumns.get(j), this.getColumnValue(j));
                            }
                            events.add(theEvent);
                            cursor.advance();
                            ++this.offset;
                        }
                        return events;
                    }

                    private Object getColumnValue(int i) {
                        BaseObjectColumnValueSelector selector = (BaseObjectColumnValueSelector)columnSelectors.get(i);
                        DateTime value = legacy && ((String)allColumns.get(i)).equals(ScanQueryEngine.LEGACY_TIMESTAMP_KEY) ? DateTimes.utc((Long)selector.getObject()) : (selector == null ? null : (DateTime)selector.getObject());
                        return value;
                    }
                };
            }

            @Override
            public void cleanup(Iterator<ScanResultValue> iterFromMake) {
            }
        })));
    }

    private long calculateRemainingScanRowsLimit(ScanQuery query, ResponseContext responseContext) {
        if (query.getOrder().equals((Object)ScanQuery.Order.NONE)) {
            return query.getScanRowsLimit() - (Long)responseContext.get(ResponseContext.Key.NUM_SCANNED_ROWS);
        }
        return query.getScanRowsLimit();
    }
}

