/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.lookup;

import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;

public class RegisteredLookupExtractionFn
implements ExtractionFn {
    private volatile LookupExtractionFn delegate = null;
    private final Object delegateLock = new Object();
    private final LookupExtractorFactoryContainerProvider manager;
    private final String lookup;
    private final boolean retainMissingValue;
    private final String replaceMissingValueWith;
    private final Boolean injective;
    private final boolean optimize;

    @JsonCreator
    public RegisteredLookupExtractionFn(@JacksonInject LookupExtractorFactoryContainerProvider manager, @JsonProperty(value="lookup") String lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @JsonProperty(value="replaceMissingValueWith") @Nullable String replaceMissingValueWith, @JsonProperty(value="injective") @Nullable Boolean injective, @JsonProperty(value="optimize") Boolean optimize) {
        Preconditions.checkArgument(lookup != null, "`lookup` required");
        this.manager = manager;
        this.replaceMissingValueWith = replaceMissingValueWith;
        this.retainMissingValue = retainMissingValue;
        this.injective = injective;
        this.optimize = optimize == null ? true : optimize;
        this.lookup = lookup;
    }

    @JsonProperty(value="lookup")
    public String getLookup() {
        return this.lookup;
    }

    @JsonProperty(value="retainMissingValue")
    public boolean isRetainMissingValue() {
        return this.retainMissingValue;
    }

    @Nullable
    @JsonProperty(value="replaceMissingValueWith")
    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    @Nullable
    @JsonProperty(value="injective")
    public Boolean isInjective() {
        return this.injective;
    }

    @JsonProperty(value="optimize")
    public boolean isOptimize() {
        return this.optimize;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] keyPrefix = StringUtils.toUtf8(this.getClass().getName());
        byte[] lookupName = StringUtils.toUtf8(this.getLookup());
        byte[] delegateKey = this.ensureDelegate().getCacheKey();
        return ByteBuffer.allocate(keyPrefix.length + 1 + lookupName.length + 1 + delegateKey.length).put(keyPrefix).put((byte)-1).put(lookupName).put((byte)-1).put(delegateKey).array();
    }

    @Override
    @Nullable
    public String apply(@Nullable Object value) {
        return this.ensureDelegate().apply(value);
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        return this.ensureDelegate().apply(value);
    }

    @Override
    public String apply(long value) {
        return this.ensureDelegate().apply(value);
    }

    @Override
    public boolean preservesOrdering() {
        return this.ensureDelegate().preservesOrdering();
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.ensureDelegate().getExtractionType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LookupExtractionFn ensureDelegate() {
        if (null == this.delegate) {
            Object object = this.delegateLock;
            synchronized (object) {
                if (null == this.delegate) {
                    LookupExtractor factory = (LookupExtractor)Preconditions.checkNotNull(this.manager.get(this.getLookup()), "Lookup [%s] not found", this.getLookup()).getLookupExtractorFactory().get();
                    this.delegate = new LookupExtractionFn(factory, this.retainMissingValue, this.replaceMissingValueWith, this.injective, this.optimize);
                }
            }
        }
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredLookupExtractionFn that = (RegisteredLookupExtractionFn)o;
        return this.retainMissingValue == that.retainMissingValue && this.optimize == that.optimize && Objects.equals(this.lookup, that.lookup) && Objects.equals(this.replaceMissingValueWith, that.replaceMissingValueWith) && Objects.equals(this.injective, that.injective);
    }

    public int hashCode() {
        return Objects.hash(this.lookup, this.retainMissingValue, this.replaceMissingValueWith, this.injective, this.optimize);
    }

    public String toString() {
        return "RegisteredLookupExtractionFn{delegate=" + this.delegate + ", lookup='" + this.lookup + '\'' + ", retainMissingValue=" + this.retainMissingValue + ", replaceMissingValueWith='" + this.replaceMissingValueWith + '\'' + ", injective=" + this.injective + ", optimize=" + this.optimize + '}';
    }
}

