/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.having;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpec;

public class AndHavingSpec
implements HavingSpec {
    private final List<HavingSpec> havingSpecs;

    @JsonCreator
    public AndHavingSpec(@JsonProperty(value="havingSpecs") List<HavingSpec> havingSpecs) {
        this.havingSpecs = havingSpecs == null ? ImmutableList.of() : havingSpecs;
    }

    @JsonProperty(value="havingSpecs")
    public List<HavingSpec> getHavingSpecs() {
        return this.havingSpecs;
    }

    @Override
    public void setQuery(GroupByQuery query) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            havingSpec.setQuery(query);
        }
    }

    @Override
    public boolean eval(ResultRow row) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            if (havingSpec.eval(row)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndHavingSpec that = (AndHavingSpec)o;
        return !(this.havingSpecs != null ? !this.havingSpecs.equals(that.havingSpecs) : that.havingSpecs != null);
    }

    public int hashCode() {
        return this.havingSpecs != null ? this.havingSpecs.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AndHavingSpec");
        sb.append("{havingSpecs=").append(this.havingSpecs);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(1).appendCacheables(this.havingSpecs).build();
    }
}

