/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.BaseQuery;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Queries;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryDataSource;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparator;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByQuery
extends BaseQuery<ResultRow> {
    public static final String CTX_KEY_SORT_BY_DIMS_FIRST = "sortByDimsFirst";
    private static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    private static final Comparator<ResultRow> NON_GRANULAR_TIME_COMP = (lhs, rhs) -> Longs.compare(lhs.getLong(0), rhs.getLong(0));
    private final VirtualColumns virtualColumns;
    private final LimitSpec limitSpec;
    @Nullable
    private final HavingSpec havingSpec;
    @Nullable
    private final DimFilter dimFilter;
    private final List<DimensionSpec> dimensions;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;
    @Nullable
    private final List<List<String>> subtotalsSpec;
    private final boolean applyLimitPushDown;
    private final Function<Sequence<ResultRow>, Sequence<ResultRow>> postProcessingFn;
    private final List<String> resultRowOrder;
    private final Object2IntMap<String> resultRowPositionLookup;
    @Nullable
    private final DateTime universalTimestamp;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public GroupByQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="filter") @Nullable DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="dimensions") List<DimensionSpec> dimensions, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="having") @Nullable HavingSpec havingSpec, @JsonProperty(value="limitSpec") LimitSpec limitSpec, @JsonProperty(value="subtotalsSpec") @Nullable List<List<String>> subtotalsSpec, @JsonProperty(value="context") Map<String, Object> context) {
        this(dataSource, querySegmentSpec, virtualColumns, dimFilter, granularity, dimensions, aggregatorSpecs, postAggregatorSpecs, havingSpec, limitSpec, subtotalsSpec, null, context);
    }

    private Function<Sequence<ResultRow>, Sequence<ResultRow>> makePostProcessingFn() {
        Function<Sequence<ResultRow>, Sequence<ResultRow>> postProcessingFn = this.limitSpec.build(this);
        if (this.havingSpec != null) {
            postProcessingFn = Functions.compose(postProcessingFn, input -> {
                this.havingSpec.setQuery(this);
                return Sequences.filter(input, this.havingSpec::eval);
            });
        }
        return postProcessingFn;
    }

    private GroupByQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, VirtualColumns virtualColumns, @Nullable DimFilter dimFilter, Granularity granularity, @Nullable List<DimensionSpec> dimensions, @Nullable List<AggregatorFactory> aggregatorSpecs, @Nullable List<PostAggregator> postAggregatorSpecs, @Nullable HavingSpec havingSpec, LimitSpec limitSpec, @Nullable List<List<String>> subtotalsSpec, @Nullable Function<Sequence<ResultRow>, Sequence<ResultRow>> postProcessingFn, Map<String, Object> context) {
        super(dataSource, querySegmentSpec, false, context, granularity);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimFilter = dimFilter;
        this.dimensions = dimensions == null ? ImmutableList.of() : dimensions;
        for (DimensionSpec spec : this.dimensions) {
            Preconditions.checkArgument(spec != null, "dimensions has null DimensionSpec");
        }
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = Queries.prepareAggregations(this.dimensions.stream().map(DimensionSpec::getOutputName).collect(Collectors.toList()), this.aggregatorSpecs, postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs);
        this.universalTimestamp = this.computeUniversalTimestamp();
        this.resultRowOrder = this.computeResultRowOrder();
        this.resultRowPositionLookup = this.computeResultRowOrderLookup();
        this.havingSpec = havingSpec;
        this.limitSpec = LimitSpec.nullToNoopLimitSpec(limitSpec);
        this.subtotalsSpec = this.verifySubtotalsSpec(subtotalsSpec, this.dimensions);
        GroupByQuery.verifyOutputNames(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        this.postProcessingFn = postProcessingFn != null ? postProcessingFn : this.makePostProcessingFn();
        this.applyLimitPushDown = this.determineApplyLimitPushDown();
    }

    @Nullable
    private List<List<String>> verifySubtotalsSpec(@Nullable List<List<String>> subtotalsSpec, List<DimensionSpec> dimensions) {
        if (subtotalsSpec != null) {
            for (List<String> subtotalSpec : subtotalsSpec) {
                for (String s : subtotalSpec) {
                    boolean found = false;
                    for (DimensionSpec ds : dimensions) {
                        if (!s.equals(ds.getOutputName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IAE("Subtotal spec %s is either not a subset of top level dimensions.", subtotalSpec);
                }
            }
        }
        return subtotalsSpec;
    }

    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @Nullable
    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @JsonProperty(value="having")
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @JsonProperty
    public LimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="subtotalsSpec")
    @Nullable
    public List<List<String>> getSubtotalsSpec() {
        return this.subtotalsSpec;
    }

    public List<String> getResultRowOrder() {
        return this.resultRowOrder;
    }

    public int getResultRowSizeWithoutPostAggregators() {
        return this.getResultRowPostAggregatorStart();
    }

    public int getResultRowSizeWithPostAggregators() {
        return this.resultRowOrder.size();
    }

    public Object2IntMap<String> getResultRowPositionLookup() {
        return this.resultRowPositionLookup;
    }

    @Nullable
    public DateTime getUniversalTimestamp() {
        return this.universalTimestamp;
    }

    public boolean getResultRowHasTimestamp() {
        return this.universalTimestamp == null;
    }

    public int getResultRowDimensionStart() {
        return this.getResultRowHasTimestamp() ? 1 : 0;
    }

    public int getResultRowAggregatorStart() {
        return this.getResultRowDimensionStart() + this.dimensions.size();
    }

    public int getResultRowPostAggregatorStart() {
        return this.getResultRowAggregatorStart() + this.aggregatorSpecs.size();
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    @Nullable
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "groupBy";
    }

    @JsonIgnore
    public boolean getContextSortByDimsFirst() {
        return this.getContextBoolean(CTX_KEY_SORT_BY_DIMS_FIRST, false);
    }

    @JsonIgnore
    public boolean isApplyLimitPushDown() {
        return this.applyLimitPushDown;
    }

    @JsonIgnore
    public boolean getApplyLimitPushDownFromContext() {
        return this.getContextBoolean("applyLimitPushDown", true);
    }

    @Override
    public Ordering getResultOrdering() {
        Ordering<ResultRow> rowOrdering = this.getRowOrdering(false);
        return Ordering.from((lhs, rhs) -> {
            if (lhs instanceof ResultRow) {
                return rowOrdering.compare((ResultRow)lhs, (ResultRow)rhs);
            }
            return Comparators.naturalNullsFirst().compare(lhs, rhs);
        });
    }

    private boolean validateAndGetForceLimitPushDown() {
        boolean forcePushDown = this.getContextBoolean("forceLimitPushDown", false);
        if (forcePushDown) {
            if (!(this.limitSpec instanceof DefaultLimitSpec)) {
                throw new IAE("When forcing limit push down, a limit spec must be provided.", new Object[0]);
            }
            if (!((DefaultLimitSpec)this.limitSpec).isLimited()) {
                throw new IAE("When forcing limit push down, the provided limit spec must have a limit.", new Object[0]);
            }
            if (this.havingSpec != null) {
                throw new IAE("Cannot force limit push down when a having spec is present.", new Object[0]);
            }
            for (OrderByColumnSpec orderBySpec : ((DefaultLimitSpec)this.limitSpec).getColumns()) {
                if (OrderByColumnSpec.getPostAggIndexForOrderBy(orderBySpec, this.postAggregatorSpecs) <= -1) continue;
                throw new UnsupportedOperationException("Limit push down when sorting by a post aggregator is not supported.");
            }
        }
        return forcePushDown;
    }

    private Object2IntMap<String> computeResultRowOrderLookup() {
        Object2IntOpenHashMap<String> indexes = new Object2IntOpenHashMap<String>();
        indexes.defaultReturnValue(-1);
        int index = 0;
        for (String columnName : this.resultRowOrder) {
            indexes.put(columnName, index++);
        }
        return indexes;
    }

    private List<String> computeResultRowOrder() {
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.universalTimestamp == null) {
            retVal.add("__time");
        }
        this.dimensions.stream().map(DimensionSpec::getOutputName).forEach(retVal::add);
        this.aggregatorSpecs.stream().map(AggregatorFactory::getName).forEach(retVal::add);
        this.postAggregatorSpecs.stream().map(PostAggregator::getName).forEach(retVal::add);
        return retVal;
    }

    private boolean determineApplyLimitPushDown() {
        if (this.subtotalsSpec != null) {
            return false;
        }
        boolean forceLimitPushDown = this.validateAndGetForceLimitPushDown();
        if (this.limitSpec instanceof DefaultLimitSpec) {
            DefaultLimitSpec defaultLimitSpec = (DefaultLimitSpec)this.limitSpec;
            if (!defaultLimitSpec.isLimited()) {
                return false;
            }
            if (forceLimitPushDown) {
                return true;
            }
            if (!this.getApplyLimitPushDownFromContext()) {
                return false;
            }
            if (this.havingSpec != null) {
                return false;
            }
            boolean sortHasNonGroupingFields = DefaultLimitSpec.sortingOrderHasNonGroupingFields((DefaultLimitSpec)this.limitSpec, this.getDimensions());
            return !sortHasNonGroupingFields;
        }
        return false;
    }

    private Ordering<ResultRow> getRowOrderingForPushDown(boolean granular, DefaultLimitSpec limitSpec) {
        boolean sortByDimsFirst = this.getContextSortByDimsFirst();
        IntArrayList orderedFieldNumbers = new IntArrayList();
        HashSet<Integer> dimsInOrderBy = new HashSet<Integer>();
        ArrayList<Boolean> needsReverseList = new ArrayList<Boolean>();
        ArrayList<ValueType> dimensionTypes = new ArrayList<ValueType>();
        ArrayList<StringComparator> comparators = new ArrayList<StringComparator>();
        for (OrderByColumnSpec orderSpec : limitSpec.getColumns()) {
            boolean needsReverse;
            boolean bl = needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
            int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
            if (dimIndex < 0) continue;
            DimensionSpec dim = this.dimensions.get(dimIndex);
            orderedFieldNumbers.add(this.resultRowPositionLookup.getInt(dim.getOutputName()));
            dimsInOrderBy.add(dimIndex);
            needsReverseList.add(needsReverse);
            ValueType type = this.dimensions.get(dimIndex).getOutputType();
            dimensionTypes.add(type);
            comparators.add(orderSpec.getDimensionComparator());
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (dimsInOrderBy.contains(i)) continue;
            orderedFieldNumbers.add(this.resultRowPositionLookup.getInt(this.dimensions.get(i).getOutputName()));
            needsReverseList.add(false);
            ValueType type = this.dimensions.get(i).getOutputType();
            dimensionTypes.add(type);
            comparators.add(StringComparators.LEXICOGRAPHIC);
        }
        Comparator<ResultRow> timeComparator = this.getTimeComparator(granular);
        if (timeComparator == null) {
            return Ordering.from((lhs, rhs) -> GroupByQuery.compareDimsForLimitPushDown(orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, lhs, rhs));
        }
        if (sortByDimsFirst) {
            return Ordering.from((lhs, rhs) -> {
                int cmp = GroupByQuery.compareDimsForLimitPushDown(orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, lhs, rhs);
                if (cmp != 0) {
                    return cmp;
                }
                return timeComparator.compare((ResultRow)lhs, (ResultRow)rhs);
            });
        }
        return Ordering.from((lhs, rhs) -> {
            int timeCompare = timeComparator.compare((ResultRow)lhs, (ResultRow)rhs);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return GroupByQuery.compareDimsForLimitPushDown(orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, lhs, rhs);
        });
    }

    public Ordering<ResultRow> getRowOrdering(boolean granular) {
        if (this.applyLimitPushDown && !DefaultLimitSpec.sortingOrderHasNonGroupingFields((DefaultLimitSpec)this.limitSpec, this.dimensions)) {
            return this.getRowOrderingForPushDown(granular, (DefaultLimitSpec)this.limitSpec);
        }
        boolean sortByDimsFirst = this.getContextSortByDimsFirst();
        Comparator<ResultRow> timeComparator = this.getTimeComparator(granular);
        if (timeComparator == null) {
            return Ordering.from((lhs, rhs) -> this.compareDims(this.dimensions, (ResultRow)lhs, (ResultRow)rhs));
        }
        if (sortByDimsFirst) {
            return Ordering.from((lhs, rhs) -> {
                int cmp = this.compareDims(this.dimensions, (ResultRow)lhs, (ResultRow)rhs);
                if (cmp != 0) {
                    return cmp;
                }
                return timeComparator.compare((ResultRow)lhs, (ResultRow)rhs);
            });
        }
        return Ordering.from((lhs, rhs) -> {
            int timeCompare = timeComparator.compare((ResultRow)lhs, (ResultRow)rhs);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return this.compareDims(this.dimensions, (ResultRow)lhs, (ResultRow)rhs);
        });
    }

    @Nullable
    private Comparator<ResultRow> getTimeComparator(boolean granular) {
        if (Granularities.ALL.equals(this.getGranularity())) {
            return null;
        }
        if (!this.getResultRowHasTimestamp()) {
            throw new ISE("Cannot do time comparisons!", new Object[0]);
        }
        if (granular) {
            return (lhs, rhs) -> Longs.compare(this.getGranularity().bucketStart(DateTimes.utc(lhs.getLong(0))).getMillis(), this.getGranularity().bucketStart(DateTimes.utc(rhs.getLong(0))).getMillis());
        }
        return NON_GRANULAR_TIME_COMP;
    }

    private int compareDims(List<DimensionSpec> dimensions, ResultRow lhs, ResultRow rhs) {
        int dimensionStart = this.getResultRowDimensionStart();
        for (int i = 0; i < dimensions.size(); ++i) {
            DimensionSpec dimension = dimensions.get(i);
            int dimCompare = DimensionHandlerUtils.compareObjectsAsType(lhs.get(dimensionStart + i), rhs.get(dimensionStart + i), dimension.getOutputType());
            if (dimCompare == 0) continue;
            return dimCompare;
        }
        return 0;
    }

    @Nullable
    private DateTime computeUniversalTimestamp() {
        String timestampStringFromContext = this.getContextValue(CTX_KEY_FUDGE_TIMESTAMP, "");
        Granularity granularity = this.getGranularity();
        if (!timestampStringFromContext.isEmpty()) {
            return DateTimes.utc(Long.parseLong(timestampStringFromContext));
        }
        if (Granularities.ALL.equals(granularity)) {
            DateTime timeStart = this.getIntervals().get(0).getStart();
            return granularity.getIterable(new Interval((ReadableInstant)timeStart, (ReadableInstant)timeStart.plus(1L))).iterator().next().getStart();
        }
        return null;
    }

    private static int compareDimsForLimitPushDown(IntList fields, List<Boolean> needsReverseList, List<ValueType> dimensionTypes, List<StringComparator> comparators, ResultRow lhs, ResultRow rhs) {
        for (int i = 0; i < fields.size(); ++i) {
            int fieldNumber = fields.getInt(i);
            StringComparator comparator = comparators.get(i);
            ValueType dimensionType = dimensionTypes.get(i);
            Object lhsObj = lhs.get(fieldNumber);
            Object rhsObj = rhs.get(fieldNumber);
            int dimCompare = ValueType.isNumeric(dimensionType) ? (comparator.equals(StringComparators.NUMERIC) ? DimensionHandlerUtils.compareObjectsAsType(lhsObj, rhsObj, dimensionType) : comparator.compare(String.valueOf(lhsObj), String.valueOf(rhsObj))) : comparator.compare((String)lhsObj, (String)rhsObj);
            if (dimCompare == 0) continue;
            return needsReverseList.get(i) != false ? -dimCompare : dimCompare;
        }
        return 0;
    }

    public Sequence<ResultRow> postProcess(Sequence<ResultRow> results) {
        return this.postProcessingFn.apply(results);
    }

    public GroupByQuery withOverriddenContext(Map<String, Object> contextOverride) {
        return new Builder(this).overrideContext(contextOverride).build();
    }

    public GroupByQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new Builder(this).setQuerySegmentSpec(spec).build();
    }

    public GroupByQuery withDimFilter(@Nullable DimFilter dimFilter) {
        return new Builder(this).setDimFilter(dimFilter).build();
    }

    @Override
    public Query<ResultRow> withDataSource(DataSource dataSource) {
        return new Builder(this).setDataSource(dataSource).build();
    }

    public GroupByQuery withDimensionSpecs(List<DimensionSpec> dimensionSpecs) {
        return new Builder(this).setDimensions(dimensionSpecs).build();
    }

    public GroupByQuery withLimitSpec(LimitSpec limitSpec) {
        return new Builder(this).setLimitSpec(limitSpec).build();
    }

    public GroupByQuery withAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
        return new Builder(this).setAggregatorSpecs(aggregatorSpecs).build();
    }

    public GroupByQuery withSubtotalsSpec(@Nullable List<List<String>> subtotalsSpec) {
        return new Builder(this).setSubtotalsSpec(subtotalsSpec).build();
    }

    public GroupByQuery withPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
        return new Builder(this).setPostAggregatorSpecs(postAggregatorSpecs).build();
    }

    private static void verifyOutputNames(List<DimensionSpec> dimensions, List<AggregatorFactory> aggregators, List<PostAggregator> postAggregators) {
        HashSet<String> outputNames = new HashSet<String>();
        for (DimensionSpec dimension : dimensions) {
            if (outputNames.add(dimension.getOutputName())) continue;
            throw new IAE("Duplicate output name[%s]", dimension.getOutputName());
        }
        for (AggregatorFactory aggregator : aggregators) {
            if (outputNames.add(aggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", aggregator.getName());
        }
        for (PostAggregator postAggregator : postAggregators) {
            if (outputNames.add(postAggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", postAggregator.getName());
        }
        if (outputNames.contains("__time")) {
            throw new IAE("'%s' cannot be used as an output name for dimensions, aggregators, or post-aggregators.", "__time");
        }
    }

    public String toString() {
        return "GroupByQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", virtualColumns=" + this.virtualColumns + ", limitSpec=" + this.limitSpec + ", dimFilter=" + this.dimFilter + ", granularity=" + this.getGranularity() + ", dimensions=" + this.dimensions + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", havingSpec=" + this.havingSpec + ", context=" + this.getContext() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByQuery that = (GroupByQuery)o;
        return Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.limitSpec, that.limitSpec) && Objects.equals(this.havingSpec, that.havingSpec) && Objects.equals(this.dimFilter, that.dimFilter) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.aggregatorSpecs, that.aggregatorSpecs) && Objects.equals(this.postAggregatorSpecs, that.postAggregatorSpecs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.virtualColumns, this.limitSpec, this.havingSpec, this.dimFilter, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
    }

    public static class Builder {
        private DataSource dataSource;
        private QuerySegmentSpec querySegmentSpec;
        private VirtualColumns virtualColumns;
        @Nullable
        private DimFilter dimFilter;
        private Granularity granularity;
        @Nullable
        private List<DimensionSpec> dimensions;
        @Nullable
        private List<AggregatorFactory> aggregatorSpecs;
        @Nullable
        private List<PostAggregator> postAggregatorSpecs;
        @Nullable
        private HavingSpec havingSpec;
        private Map<String, Object> context;
        @Nullable
        private List<List<String>> subtotalsSpec = null;
        @Nullable
        private LimitSpec limitSpec = null;
        @Nullable
        private Function<Sequence<ResultRow>, Sequence<ResultRow>> postProcessingFn;
        private List<OrderByColumnSpec> orderByColumnSpecs = new ArrayList<OrderByColumnSpec>();
        private int limit = Integer.MAX_VALUE;

        @Nullable
        private static List<List<String>> copySubtotalSpec(@Nullable List<List<String>> subtotalsSpec) {
            if (subtotalsSpec == null) {
                return null;
            }
            return subtotalsSpec.stream().map(ArrayList::new).collect(Collectors.toList());
        }

        public Builder() {
        }

        public Builder(GroupByQuery query) {
            this.dataSource = query.getDataSource();
            this.querySegmentSpec = query.getQuerySegmentSpec();
            this.virtualColumns = query.getVirtualColumns();
            this.dimFilter = query.getDimFilter();
            this.granularity = query.getGranularity();
            this.dimensions = query.getDimensions();
            this.aggregatorSpecs = query.getAggregatorSpecs();
            this.postAggregatorSpecs = query.getPostAggregatorSpecs();
            this.havingSpec = query.getHavingSpec();
            this.limitSpec = query.getLimitSpec();
            this.subtotalsSpec = query.subtotalsSpec;
            this.postProcessingFn = query.postProcessingFn;
            this.context = query.getContext();
        }

        public Builder(Builder builder) {
            this.dataSource = builder.dataSource;
            this.querySegmentSpec = builder.querySegmentSpec;
            this.virtualColumns = builder.virtualColumns;
            this.dimFilter = builder.dimFilter;
            this.granularity = builder.granularity;
            this.dimensions = builder.dimensions;
            this.aggregatorSpecs = builder.aggregatorSpecs;
            this.postAggregatorSpecs = builder.postAggregatorSpecs;
            this.havingSpec = builder.havingSpec;
            this.limitSpec = builder.limitSpec;
            this.subtotalsSpec = Builder.copySubtotalSpec(builder.subtotalsSpec);
            this.postProcessingFn = builder.postProcessingFn;
            this.limit = builder.limit;
            this.orderByColumnSpecs = new ArrayList<OrderByColumnSpec>(builder.orderByColumnSpecs);
            this.context = builder.context;
        }

        public Builder setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = new TableDataSource(dataSource);
            return this;
        }

        public Builder setDataSource(Query query) {
            this.dataSource = new QueryDataSource(query);
            return this;
        }

        public Builder setInterval(QuerySegmentSpec interval) {
            return this.setQuerySegmentSpec(interval);
        }

        public Builder setInterval(List<Interval> intervals) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec((Object)intervals));
        }

        public Builder setInterval(Interval interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder setInterval(String interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder setVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = Preconditions.checkNotNull(virtualColumns, "virtualColumns");
            return this;
        }

        public Builder setVirtualColumns(VirtualColumn ... virtualColumns) {
            this.virtualColumns = VirtualColumns.create(Arrays.asList(virtualColumns));
            return this;
        }

        public Builder setLimit(int limit) {
            this.ensureExplicitLimitSpecNotSet();
            this.limit = limit;
            this.postProcessingFn = null;
            return this;
        }

        public Builder setSubtotalsSpec(@Nullable List<List<String>> subtotalsSpec) {
            this.subtotalsSpec = subtotalsSpec;
            return this;
        }

        public Builder addOrderByColumn(String dimension) {
            return this.addOrderByColumn(dimension, null);
        }

        public Builder addOrderByColumn(String dimension, @Nullable OrderByColumnSpec.Direction direction) {
            return this.addOrderByColumn(new OrderByColumnSpec(dimension, direction));
        }

        public Builder addOrderByColumn(OrderByColumnSpec columnSpec) {
            this.ensureExplicitLimitSpecNotSet();
            this.orderByColumnSpecs.add(columnSpec);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setLimitSpec(LimitSpec limitSpec) {
            Preconditions.checkNotNull(limitSpec);
            this.ensureFluentLimitsNotSet();
            this.limitSpec = limitSpec;
            this.postProcessingFn = null;
            return this;
        }

        private void ensureExplicitLimitSpecNotSet() {
            if (this.limitSpec != null) {
                throw new ISE("Ambiguous build, limitSpec[%s] already set", this.limitSpec);
            }
        }

        private void ensureFluentLimitsNotSet() {
            if (this.limit != Integer.MAX_VALUE || !this.orderByColumnSpecs.isEmpty()) {
                throw new ISE("Ambiguous build, limit[%s] or columnSpecs[%s] already set.", this.limit, this.orderByColumnSpecs);
            }
        }

        public Builder setQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
            this.querySegmentSpec = querySegmentSpec;
            return this;
        }

        public Builder setDimFilter(@Nullable DimFilter dimFilter) {
            this.dimFilter = dimFilter;
            return this;
        }

        public Builder setGranularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public Builder addDimension(String column) {
            return this.addDimension(column, column);
        }

        public Builder addDimension(String column, String outputName) {
            return this.addDimension(new DefaultDimensionSpec(column, outputName));
        }

        public Builder addDimension(DimensionSpec dimension) {
            if (this.dimensions == null) {
                this.dimensions = new ArrayList<DimensionSpec>();
            }
            this.dimensions.add(dimension);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setDimensions(List<DimensionSpec> dimensions) {
            this.dimensions = Lists.newArrayList(dimensions);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setDimensions(DimensionSpec ... dimensions) {
            this.dimensions = new ArrayList<DimensionSpec>(Arrays.asList(dimensions));
            this.postProcessingFn = null;
            return this;
        }

        public Builder addAggregator(AggregatorFactory aggregator) {
            if (this.aggregatorSpecs == null) {
                this.aggregatorSpecs = new ArrayList<AggregatorFactory>();
            }
            this.aggregatorSpecs.add(aggregator);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
            this.aggregatorSpecs = Lists.newArrayList(aggregatorSpecs);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setAggregatorSpecs(AggregatorFactory ... aggregatorSpecs) {
            this.aggregatorSpecs = new ArrayList<AggregatorFactory>(Arrays.asList(aggregatorSpecs));
            this.postProcessingFn = null;
            return this;
        }

        public Builder setPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
            this.postAggregatorSpecs = Lists.newArrayList(postAggregatorSpecs);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setContext(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder overrideContext(Map<String, Object> contextOverride) {
            this.context = GroupByQuery.computeOverriddenContext(this.context, contextOverride);
            return this;
        }

        public Builder setHavingSpec(@Nullable HavingSpec havingSpec) {
            this.havingSpec = havingSpec;
            this.postProcessingFn = null;
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public GroupByQuery build() {
            LimitSpec theLimitSpec = this.limitSpec == null ? (this.orderByColumnSpecs.isEmpty() && this.limit == Integer.MAX_VALUE ? NoopLimitSpec.instance() : new DefaultLimitSpec(this.orderByColumnSpecs, this.limit)) : this.limitSpec;
            return new GroupByQuery(this.dataSource, this.querySegmentSpec, this.virtualColumns, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, theLimitSpec, this.subtotalsSpec, this.postProcessingFn, this.context);
        }
    }
}

