/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter.vector;

import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.hive.druid.org.apache.druid.segment.IdLookup;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;

public class MultiValueStringVectorValueMatcher
implements VectorValueMatcherFactory {
    private final MultiValueDimensionVectorSelector selector;

    public MultiValueStringVectorValueMatcher(MultiValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        final String etnValue = NullHandling.emptyToNullIfNeeded(NullHandling.emptyToNullIfNeeded(value));
        IdLookup idLookup = this.selector.idLookup();
        if (idLookup != null) {
            final int id = idLookup.lookupId(etnValue);
            if (id < 0) {
                return BooleanVectorValueMatcher.of(this.selector, false);
            }
            return new BaseVectorValueMatcher(this.selector){
                final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask) {
                    IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        IndexedInts ints = vector[rowNum];
                        int n = ints.size();
                        if (n == 0) {
                            if (etnValue != null) continue;
                            selection[numRows++] = rowNum;
                            continue;
                        }
                        for (int j = 0; j < n; ++j) {
                            if (ints.get(j) != id) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                    }
                    this.match.setSelectionSize(numRows);
                    assert (this.match.isValid(mask));
                    return this.match;
                }
            };
        }
        return this.makeMatcher(s -> Objects.equals(s, etnValue));
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        return this.makeMatcher(predicateFactory.makeStringPredicate());
    }

    private VectorValueMatcher makeMatcher(final Predicate<String> predicate) {
        final boolean matchNull = predicate.apply(null);
        if (this.selector.getValueCardinality() > 0) {
            final BitSet checkedIds = new BitSet(this.selector.getValueCardinality());
            final BitSet matchingIds = new BitSet(this.selector.getValueCardinality());
            return new BaseVectorValueMatcher(this.selector){
                private final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask) {
                    IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        IndexedInts ints = vector[rowNum];
                        int n = ints.size();
                        if (n == 0) {
                            if (!matchNull) continue;
                            selection[numRows++] = rowNum;
                            continue;
                        }
                        for (int j = 0; j < n; ++j) {
                            boolean matches;
                            int id = ints.get(j);
                            if (checkedIds.get(id)) {
                                matches = matchingIds.get(id);
                            } else {
                                matches = predicate.apply(MultiValueStringVectorValueMatcher.this.selector.lookupName(id));
                                checkedIds.set(id);
                                if (matches) {
                                    matchingIds.set(id);
                                }
                            }
                            if (!matches) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                    }
                    this.match.setSelectionSize(numRows);
                    assert (this.match.isValid(mask));
                    return this.match;
                }
            };
        }
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    IndexedInts ints = vector[rowNum];
                    int n = ints.size();
                    if (n == 0) {
                        if (!matchNull) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    for (int j = 0; j < n; ++j) {
                        int id = ints.get(j);
                        if (!predicate.apply(MultiValueStringVectorValueMatcher.this.selector.lookupName(id))) continue;
                        selection[numRows++] = rowNum;
                        continue block0;
                    }
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }
}

