/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public class LongVectorValueMatcher
implements VectorValueMatcherFactory {
    private final VectorValueSelector selector;
    private final boolean canHaveNulls = !NullHandling.replaceWithDefault();

    public LongVectorValueMatcher(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        if (value == null && this.canHaveNulls) {
            return this.makeNullValueMatcher(this.selector);
        }
        Long matchVal = DimensionHandlerUtils.convertObjectToLong(value);
        if (matchVal == null) {
            return BooleanVectorValueMatcher.of(this.selector, false);
        }
        final long matchValLong = matchVal;
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[LongVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                long[] vector = LongVectorValueMatcher.this.selector.getLongVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (vector[rowNum] != matchValLong) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final DruidLongPredicate predicate = predicateFactory.makeLongPredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[LongVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                long[] vector = LongVectorValueMatcher.this.selector.getLongVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (!predicate.applyLong(vector[rowNum])) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }
}

