/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.DoubleValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.filter.FloatValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.filter.LongValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.filter.StringValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;

public class ValueMatcherColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<ValueMatcherColumnSelectorStrategy> {
    private static final ValueMatcherColumnSelectorStrategyFactory INSTANCE = new ValueMatcherColumnSelectorStrategyFactory();

    private ValueMatcherColumnSelectorStrategyFactory() {
    }

    public static ValueMatcherColumnSelectorStrategyFactory instance() {
        return INSTANCE;
    }

    @Override
    public ValueMatcherColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType type = capabilities.getType();
        switch (type) {
            case STRING: {
                return new StringValueMatcherColumnSelectorStrategy(capabilities.hasMultipleValues());
            }
            case LONG: {
                return new LongValueMatcherColumnSelectorStrategy();
            }
            case FLOAT: {
                return new FloatValueMatcherColumnSelectorStrategy();
            }
            case DOUBLE: {
                return new DoubleValueMatcherColumnSelectorStrategy();
            }
        }
        throw new IAE("Cannot create column selector strategy from invalid type [%s]", new Object[]{type});
    }
}

