/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.FilterTuning;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.segment.filter.SearchQueryFilter;

public class SearchQueryDimFilter
implements DimFilter {
    private final String dimension;
    private final SearchQuerySpec query;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;

    public SearchQueryDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="query") SearchQuerySpec query, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        Preconditions.checkArgument(query != null, "query must not be null");
        this.dimension = dimension;
        this.query = query;
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
    }

    @VisibleForTesting
    public SearchQueryDimFilter(String dimension, SearchQuerySpec query, @Nullable ExtractionFn extractionFn) {
        this(dimension, query, extractionFn, null);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public SearchQuerySpec getQuery() {
        return this.query;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] queryBytes = this.query.getCacheKey();
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + queryBytes.length + extractionFnBytes.length).put((byte)6).put(dimensionBytes).put((byte)-1).put(queryBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new SearchQueryFilter(this.dimension, this.query, this.extractionFn, this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of(this.dimension);
    }

    public String toString() {
        return "SearchQueryDimFilter{dimension='" + this.dimension + '\'' + ", query=" + this.query + ", extractionFn='" + this.extractionFn + '\'' + ", filterTuning=" + this.filterTuning + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQueryDimFilter that = (SearchQueryDimFilter)o;
        return this.dimension.equals(that.dimension) && this.query.equals(that.query) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.query, this.extractionFn, this.filterTuning);
    }
}

