/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilterUtils;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilters;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.segment.filter.Filters;
import org.apache.hive.druid.org.apache.druid.segment.filter.OrFilter;

public class OrDimFilter
implements DimFilter {
    private static final Joiner OR_JOINER = Joiner.on(" || ");
    private final List<DimFilter> fields;

    @JsonCreator
    public OrDimFilter(@JsonProperty(value="fields") List<DimFilter> fields) {
        fields = DimFilters.filterNulls(fields);
        Preconditions.checkArgument(fields.size() > 0, "OR operator requires at least one field");
        this.fields = fields;
    }

    public OrDimFilter(DimFilter ... fields) {
        this(Arrays.asList(fields));
    }

    public OrDimFilter(String dimensionName, String value, String ... values) {
        this.fields = new ArrayList<DimFilter>(values.length + 1);
        this.fields.add(new SelectorDimFilter(dimensionName, value, null));
        for (String val : values) {
            this.fields.add(new SelectorDimFilter(dimensionName, val, null));
        }
    }

    @JsonProperty
    public List<DimFilter> getFields() {
        return this.fields;
    }

    @Override
    public byte[] getCacheKey() {
        return DimFilterUtils.computeCacheKey((byte)2, this.fields);
    }

    @Override
    public DimFilter optimize() {
        List<DimFilter> elements = DimFilters.optimize(this.fields);
        return elements.size() == 1 ? elements.get(0) : new OrDimFilter(elements);
    }

    @Override
    public Filter toFilter() {
        return new OrFilter(Filters.toFilters(this.fields));
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        TreeRangeSet<String> retSet = TreeRangeSet.create();
        for (DimFilter field : this.fields) {
            RangeSet<String> rangeSet = field.getDimensionRangeSet(dimension);
            if (rangeSet == null) {
                return null;
            }
            retSet.addAll(rangeSet);
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        HashSet<String> requiredColumns = new HashSet<String>();
        this.fields.forEach(field -> requiredColumns.addAll(field.getRequiredColumns()));
        return requiredColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrDimFilter that = (OrDimFilter)o;
        return !(this.fields != null ? !this.fields.equals(that.fields) : that.fields != null);
    }

    public int hashCode() {
        return this.fields != null ? this.fields.hashCode() : 0;
    }

    public String toString() {
        return StringUtils.format("(%s)", OR_JOINER.join(this.fields));
    }
}

