/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;

@JsonTypeName(value="map")
public class MapLookupExtractor
extends LookupExtractor {
    private final Map<String, String> map;
    private final boolean isOneToOne;

    @JsonCreator
    public MapLookupExtractor(@JsonProperty(value="map") Map<String, String> map, @JsonProperty(value="isOneToOne") boolean isOneToOne) {
        this.map = Preconditions.checkNotNull(map, "map");
        this.isOneToOne = isOneToOne;
    }

    @JsonProperty
    public Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.map);
    }

    @Override
    @Nullable
    public String apply(@Nullable String key) {
        String keyEquivalent = NullHandling.nullToEmptyIfNeeded(key);
        if (keyEquivalent == null) {
            return null;
        }
        return NullHandling.emptyToNullIfNeeded(this.map.get(keyEquivalent));
    }

    @Override
    public List<String> unapply(@Nullable String value) {
        String valueToLookup = NullHandling.nullToEmptyIfNeeded(value);
        if (valueToLookup == null) {
            return Collections.emptyList();
        }
        return this.map.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(valueToLookup)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="isOneToOne")
    public boolean isOneToOne() {
        return this.isOneToOne;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!Strings.isNullOrEmpty(key)) {
                    outputStream.write(StringUtils.toUtf8(key));
                }
                outputStream.write(-1);
                if (!Strings.isNullOrEmpty(val)) {
                    outputStream.write(StringUtils.toUtf8(val));
                }
                outputStream.write(-1);
            }
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLookupExtractor that = (MapLookupExtractor)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

