/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expressions;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.org.apache.druid.guice.BloomFilterSerializersModule;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprType;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;

public class BloomFilterExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "bloom_filter_test";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        BloomKFilter filter;
        if (args.size() != 2) {
            throw new IAE("Function[%s] must have 2 arguments", this.name());
        }
        Expr arg = args.get(0);
        Expr filterExpr = args.get(1);
        if (!filterExpr.isLiteral() || filterExpr.getLiteralValue() == null) {
            throw new IAE("Function[%s] second argument must be a base64 serialized bloom filter", this.name());
        }
        String serializedFilter = filterExpr.getLiteralValue().toString();
        byte[] decoded = StringUtils.decodeBase64String(serializedFilter);
        try {
            filter = BloomFilterSerializersModule.bloomKFilterFromBytes(decoded);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to deserialize bloom filter", ioe);
        }
        class BloomExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ BloomKFilter val$filter;

            BloomExpr(Expr arg) {
                this.val$filter = bloomKFilter;
                super(arg);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval evaluated = this.arg.eval(bindings);
                boolean matches = false;
                switch (evaluated.type()) {
                    case STRING: {
                        String stringVal = (String)evaluated.value();
                        if (stringVal == null) {
                            matches = this.nullMatch();
                            break;
                        }
                        matches = this.val$filter.testString(stringVal);
                        break;
                    }
                    case DOUBLE: {
                        Double doubleVal = (Double)evaluated.value();
                        if (doubleVal == null) {
                            matches = this.nullMatch();
                            break;
                        }
                        matches = this.val$filter.testDouble(doubleVal);
                        break;
                    }
                    case LONG: {
                        Long longVal = (Long)evaluated.value();
                        matches = longVal == null ? this.nullMatch() : this.val$filter.testLong(longVal);
                    }
                }
                return ExprEval.of(matches, ExprType.LONG);
            }

            private boolean nullMatch() {
                return this.val$filter.testBytes(null, 0, 0);
            }

            @Override
            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit(new BloomExpr(newArg));
            }
        }
        return new BloomExpr(arg);
    }
}

