/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.expression.ExprUtils;
import org.joda.time.DateTime;

public class TimestampCeilExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "timestamp_ceil";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", this.name());
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampCeilExpr(args);
        }
        return new TimestampCeilDynamicExpr(args);
    }

    private static PeriodGranularity getGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    private static class TimestampCeilDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampCeilDynamicExpr(List<Expr> args) {
            super(args);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            DateTime bucketStartTime;
            PeriodGranularity granularity = TimestampCeilExprMacro.getGranularity(this.args, bindings);
            DateTime argTime = DateTimes.utc(((Expr)this.args.get(0)).eval(bindings).asLong());
            if (argTime.equals((Object)(bucketStartTime = granularity.bucketStart(argTime)))) {
                return ExprEval.of(bucketStartTime.getMillis());
            }
            return ExprEval.of(granularity.increment(bucketStartTime).getMillis());
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit(new TimestampCeilDynamicExpr(newArgs));
        }
    }

    private static class TimestampCeilExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Granularity granularity;

        TimestampCeilExpr(List<Expr> args) {
            super(args);
            this.granularity = TimestampCeilExprMacro.getGranularity(args, ExprUtils.nilBindings());
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            DateTime bucketStartTime;
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            DateTime argTime = DateTimes.utc(eval.asLong());
            if (argTime.equals((Object)(bucketStartTime = this.granularity.bucketStart(argTime)))) {
                return ExprEval.of(bucketStartTime.getMillis());
            }
            return ExprEval.of(this.granularity.increment(bucketStartTime).getMillis());
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit(new TimestampCeilExpr(newArgs));
        }
    }
}

