/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.mean;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.DoubleMeanHolder;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleMeanVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public DoubleMeanVectorAggregator(VectorValueSelector selector) {
        this.selector = Preconditions.checkNotNull(selector, "selector");
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        DoubleMeanHolder.init(buf, position);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        for (int i = startRow; i < endRow; ++i) {
            DoubleMeanHolder.update(buf, position, vector[i]);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        double[] vector = this.selector.getDoubleVector();
        for (int i = 0; i < numRows; ++i) {
            double val = vector[rows != null ? rows[i] : i];
            DoubleMeanHolder.update(buf, positions[i] + positionOffset, val);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return DoubleMeanHolder.get(buf, position);
    }

    @Override
    public void close() {
    }
}

