/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.mean;

import java.util.List;
import org.apache.hive.druid.org.apache.druid.java.util.common.Numbers;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.DoubleMeanHolder;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;

public class DoubleMeanAggregator
implements Aggregator {
    private final ColumnValueSelector selector;
    private final DoubleMeanHolder value = new DoubleMeanHolder(0.0, 0L);

    public DoubleMeanAggregator(ColumnValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void aggregate() {
        Object update = this.selector.getObject();
        if (update instanceof DoubleMeanHolder) {
            this.value.update((DoubleMeanHolder)update);
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                this.value.update(Numbers.tryParseDouble(o, 0.0));
            }
        } else {
            this.value.update(Numbers.tryParseDouble(update, 0.0));
        }
    }

    @Override
    public Object get() {
        return this.value;
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void close() {
    }
}

