/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.cardinality;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog.HyperUniquesBufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;

public class CardinalityBufferAggregator
implements BufferAggregator {
    private final ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses;
    private final boolean byRow;

    CardinalityBufferAggregator(ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, boolean byRow) {
        this.selectorPluses = selectorPluses;
        this.byRow = byRow;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        HyperUniquesBufferAggregator.doInit(buf, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
        buf.position(position);
        try {
            HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
            if (this.byRow) {
                CardinalityAggregator.hashRow(this.selectorPluses, collector);
            } else {
                CardinalityAggregator.hashValues(this.selectorPluses, collector);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return HyperUniquesBufferAggregator.doGet(buf, position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregators does not support getDouble()");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        for (int i = 0; i < this.selectorPluses.length; ++i) {
            inspector.visit(StringUtils.format("selector-%d", i), this.selectorPluses[i].getSelector());
        }
    }
}

