/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.bloom;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BaseBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;

public final class StringBloomFilterAggregator
extends BaseBloomFilterAggregator<DimensionSelector> {
    StringBloomFilterAggregator(DimensionSelector selector, int maxNumEntries, boolean onHeap) {
        super(selector, maxNumEntries, onHeap);
    }

    @Override
    public void bufferAdd(ByteBuffer buf) {
        StringBloomFilterAggregator.stringBufferAdd(buf, (DimensionSelector)this.selector);
    }

    static void stringBufferAdd(ByteBuffer buf, DimensionSelector selector) {
        if (selector.getRow().size() > 1) {
            selector.getRow().forEach(v -> {
                String value = selector.lookupName(v);
                if (value == null) {
                    BloomKFilter.addBytes(buf, null, 0, 0);
                } else {
                    BloomKFilter.addString(buf, value);
                }
            });
        } else {
            String value = (String)selector.getObject();
            if (value == null) {
                BloomKFilter.addBytes(buf, null, 0, 0);
            } else {
                BloomKFilter.addString(buf, value);
            }
        }
    }
}

