/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.bloom;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;

public abstract class BaseBloomFilterAggregator<TSelector>
implements BufferAggregator,
Aggregator {
    @Nullable
    private final ByteBuffer collector;
    protected final int maxNumEntries;
    protected final TSelector selector;

    BaseBloomFilterAggregator(TSelector selector, int maxNumEntries, boolean onHeap) {
        this.selector = selector;
        this.maxNumEntries = maxNumEntries;
        if (onHeap) {
            BloomKFilter bloomFilter = new BloomKFilter(maxNumEntries);
            this.collector = ByteBuffer.allocate(BloomKFilter.computeSizeBytes(maxNumEntries));
            BloomKFilter.serialize(this.collector, bloomFilter);
        } else {
            this.collector = null;
        }
    }

    abstract void bufferAdd(ByteBuffer var1);

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        BloomKFilter filter = new BloomKFilter(this.maxNumEntries);
        BloomKFilter.serialize(mutationBuffer, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            this.bufferAdd(buf);
        }
        finally {
            buf.position(oldPosition);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        int sizeBytes = BloomKFilter.computeSizeBytes(this.maxNumEntries);
        mutationBuffer.limit(position + sizeBytes);
        ByteBuffer resultCopy = ByteBuffer.allocate(sizeBytes);
        resultCopy.put(mutationBuffer.slice());
        resultCopy.rewind();
        return resultCopy;
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getDouble()");
    }

    @Override
    public void aggregate() {
        this.aggregate(this.collector, 0);
    }

    @Override
    @Nullable
    public Object get() {
        return this.collector;
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

