/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.hive.druid.org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.org.apache.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.org.apache.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.hive.druid.org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.hive.druid.org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class SerializablePairLongStringSerde
extends ComplexMetricSerde {
    private static final String TYPE_NAME = "serializablePairLongString";

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<SerializablePairLongString> extractedClass() {
                return SerializablePairLongString.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                return inputRow.getRaw(metricName);
            }
        };
    }

    @Override
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder columnBuilder) {
        GenericIndexed column = GenericIndexed.read(buffer, this.getObjectStrategy(), columnBuilder.getFileMapper());
        columnBuilder.setComplexColumnSupplier(new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    @Override
    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<SerializablePairLongString>(){

            @Override
            public int compare(@Nullable SerializablePairLongString o1, @Nullable SerializablePairLongString o2) {
                return StringFirstAggregatorFactory.VALUE_COMPARATOR.compare(o1, o2);
            }

            @Override
            public Class<? extends SerializablePairLongString> getClazz() {
                return SerializablePairLongString.class;
            }

            @Override
            public SerializablePairLongString fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
                long lhs = readOnlyBuffer.getLong();
                int stringSize = readOnlyBuffer.getInt();
                String lastString = null;
                if (stringSize > 0) {
                    byte[] stringBytes = new byte[stringSize];
                    readOnlyBuffer.get(stringBytes, 0, stringSize);
                    lastString = StringUtils.fromUtf8(stringBytes);
                }
                return new SerializablePairLongString(lhs, lastString);
            }

            @Override
            public byte[] toBytes(SerializablePairLongString val) {
                ByteBuffer bbuf;
                String rhsString = (String)val.rhs;
                if (rhsString != null) {
                    byte[] rhsBytes = StringUtils.toUtf8(rhsString);
                    bbuf = ByteBuffer.allocate(12 + rhsBytes.length);
                    bbuf.putLong((Long)val.lhs);
                    bbuf.putInt(8, rhsBytes.length);
                    bbuf.position(12);
                    bbuf.put(rhsBytes);
                } else {
                    bbuf = ByteBuffer.allocate(12);
                    bbuf.putLong((Long)val.lhs);
                    bbuf.putInt(8, 0);
                }
                return bbuf.array();
            }
        };
    }

    @Override
    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create(segmentWriteOutMedium, column, this.getObjectStrategy());
    }
}

