/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountBufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountVectorAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregateCombiner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class CountAggregatorFactory
extends AggregatorFactory {
    private final String name;

    @JsonCreator
    public CountAggregatorFactory(@JsonProperty(value="name") String name) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        this.name = name;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new CountAggregator();
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new CountBufferAggregator();
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return new CountVectorAggregator();
    }

    @Override
    public Comparator getComparator() {
        return CountAggregator.COMPARATOR;
    }

    @Override
    public boolean canVectorize() {
        return true;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return CountAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new LongSumAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongSumAggregatorFactory(this.name, this.name);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new CountAggregatorFactory(this.name));
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return ImmutableList.of();
    }

    @Override
    public byte[] getCacheKey() {
        return new byte[]{0};
    }

    @Override
    public String getTypeName() {
        return "long";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    public String toString() {
        return "CountAggregatorFactory{name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountAggregatorFactory that = (CountAggregatorFactory)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

