/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.MergeIterable;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryWatcher;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;

public class ChainedExecutionQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(ChainedExecutionQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final ListeningExecutorService exec;
    private final QueryWatcher queryWatcher;

    public ChainedExecutionQueryRunner(ExecutorService exec, QueryWatcher queryWatcher, QueryRunner<T> ... queryables) {
        this(exec, queryWatcher, Arrays.asList(queryables));
    }

    public ChainedExecutionQueryRunner(ExecutorService exec, QueryWatcher queryWatcher, Iterable<QueryRunner<T>> queryables) {
        this.exec = MoreExecutors.listeningDecorator(exec);
        this.queryables = Iterables.unmodifiableIterable(queryables);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final ResponseContext responseContext) {
        final Query<T> query = queryPlus.getQuery();
        final int priority = QueryContexts.getPriority(query);
        final Ordering<T> ordering = query.getResultOrdering();
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        return new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            @Override
            public Iterator<T> make() {
                ListenableFuture futures = Futures.allAsList(Lists.newArrayList(Iterables.transform(ChainedExecutionQueryRunner.this.queryables, input -> {
                    if (input == null) {
                        throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                    }
                    return ChainedExecutionQueryRunner.this.exec.submit(new AbstractPrioritizedCallable<Iterable<T>>(priority, (QueryRunner)input, threadSafeQueryPlus, responseContext){
                        final /* synthetic */ QueryRunner val$input;
                        final /* synthetic */ QueryPlus val$threadSafeQueryPlus;
                        final /* synthetic */ ResponseContext val$responseContext;
                        {
                            this.val$input = queryRunner;
                            this.val$threadSafeQueryPlus = queryPlus;
                            this.val$responseContext = responseContext;
                            super(priority);
                        }

                        @Override
                        public Iterable<T> call() {
                            try {
                                Sequence result = this.val$input.run(this.val$threadSafeQueryPlus, this.val$responseContext);
                                if (result == null) {
                                    throw new ISE("Got a null result! Segments are missing!", new Object[0]);
                                }
                                List retVal = result.toList();
                                if (retVal == null) {
                                    throw new ISE("Got a null list of results! WTF?!", new Object[0]);
                                }
                                return retVal;
                            }
                            catch (QueryInterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            catch (Exception e) {
                                log.noStackTrace().error(e, "Exception with one of the sequences!", new Object[0]);
                                Throwables.propagateIfPossible(e);
                                throw new RuntimeException(e);
                            }
                        }
                    });
                })));
                ChainedExecutionQueryRunner.this.queryWatcher.registerQuery(query, futures);
                try {
                    return new MergeIterable(ordering.nullsFirst(), QueryContexts.hasTimeout(query) ? (Iterable)futures.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS) : (Iterable)futures.get()).iterator();
                }
                catch (InterruptedException e) {
                    log.noStackTrace().warn(e, "Query interrupted, cancelling pending results, query id [%s]", query.getId());
                    futures.cancel(true);
                    throw new QueryInterruptedException(e);
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException(e);
                }
                catch (TimeoutException e) {
                    log.warn("Query timeout, cancelling pending results for query id [%s]", query.getId());
                    futures.cancel(true);
                    throw new QueryInterruptedException(e);
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfPossible(e.getCause());
                    throw new RuntimeException(e.getCause());
                }
            }

            @Override
            public void cleanup(Iterator<T> tIterator) {
            }
        });
    }
}

