/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.druid.indexer.TaskInfo;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.metadata.EntryExistsException;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageActionHandler;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.hive.druid.org.apache.druid.metadata.PasswordProvider;
import org.apache.hive.druid.org.apache.druid.metadata.PasswordProviderRedactionMixIn;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

public abstract class SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
implements MetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataStorageActionHandler.class);
    private final SQLMetadataConnector connector;
    private final ObjectMapper jsonMapper;
    private final TypeReference<EntryType> entryType;
    private final TypeReference<StatusType> statusType;
    private final TypeReference<LogType> logType;
    private final TypeReference<LockType> lockType;
    private final String entryTypeName;
    private final String entryTable;
    private final String logTable;
    private final String lockTable;
    private final TaskInfoMapper<EntryType, StatusType> taskInfoMapper;

    public SQLMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        this.connector = connector;
        this.jsonMapper = jsonMapper.copy().addMixIn(PasswordProvider.class, PasswordProviderRedactionMixIn.class);
        this.entryType = types.getEntryType();
        this.statusType = types.getStatusType();
        this.logType = types.getLogType();
        this.lockType = types.getLockType();
        this.entryTypeName = entryTypeName;
        this.entryTable = entryTable;
        this.logTable = logTable;
        this.lockTable = lockTable;
        this.taskInfoMapper = new TaskInfoMapper<EntryType, StatusType>(jsonMapper, this.entryType, this.statusType);
    }

    protected SQLMetadataConnector getConnector() {
        return this.connector;
    }

    protected ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    protected TypeReference<StatusType> getStatusType() {
        return this.statusType;
    }

    protected String getEntryTable() {
        return this.entryTable;
    }

    protected String getLogTable() {
        return this.logTable;
    }

    protected String getEntryTypeName() {
        return this.entryTypeName;
    }

    public TypeReference<EntryType> getEntryType() {
        return this.entryType;
    }

    @Override
    public void insert(String id, DateTime timestamp, String dataSource, EntryType entry, boolean active, StatusType status) throws EntryExistsException {
        try {
            this.getConnector().retryWithHandle(handle -> {
                String sql = StringUtils.format("INSERT INTO %s (id, created_date, datasource, payload, active, status_payload) VALUES (:id, :created_date, :datasource, :payload, :active, :status_payload)", this.getEntryTable());
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(sql).bind("id", id)).bind("created_date", timestamp.toString())).bind("datasource", dataSource)).bind("payload", this.jsonMapper.writeValueAsBytes(entry))).bind("active", active)).bind("status_payload", this.jsonMapper.writeValueAsBytes(status))).execute();
                return null;
            }, e -> this.getConnector().isTransientException((Throwable)e) && (!SQLMetadataStorageActionHandler.isStatementException(e) || !this.getEntry(id).isPresent()));
        }
        catch (Exception e2) {
            if (SQLMetadataStorageActionHandler.isStatementException(e2) && this.getEntry(id).isPresent()) {
                throw new EntryExistsException(id, e2);
            }
            Throwables.propagateIfPossible(e2);
            throw new RuntimeException(e2);
        }
    }

    @VisibleForTesting
    protected static boolean isStatementException(Throwable e) {
        return e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
    }

    @Override
    public boolean setStatus(final String entryId, final boolean active, final StatusType status) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            @Override
            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)((Update)handle.createStatement(StringUtils.format("UPDATE %s SET active = :active, status_payload = :status_payload WHERE id = :id AND active = TRUE", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).bind("active", active)).bind("status_payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(status))).execute() == 1;
            }
        });
    }

    @Override
    public Optional<EntryType> getEntry(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<EntryType>>(){

            @Override
            public Optional<EntryType> withHandle(Handle handle) throws Exception {
                byte[] res = ((Query)handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE id = :id", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).map(ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.entryType));
            }
        });
    }

    @Override
    public Optional<StatusType> getStatus(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<StatusType>>(){

            @Override
            public Optional<StatusType> withHandle(Handle handle) throws Exception {
                byte[] res = ((Query)handle.createQuery(StringUtils.format("SELECT status_payload FROM %s WHERE id = :id", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).map(ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.statusType));
            }
        });
    }

    @Override
    @Nullable
    public TaskInfo<EntryType, StatusType> getTaskInfo(String entryId) {
        return this.connector.retryWithHandle(handle -> {
            String query = StringUtils.format("SELECT id, status_payload, payload, datasource, created_date FROM %s WHERE id = :id", this.entryTable);
            return (TaskInfo)((Query)handle.createQuery(query).bind("id", entryId)).map(this.taskInfoMapper).first();
        });
    }

    @Override
    public List<TaskInfo<EntryType, StatusType>> getCompletedTaskInfo(DateTime timestamp, @Nullable Integer maxNumStatuses, @Nullable String dataSource) {
        return this.getConnector().retryWithHandle(handle -> {
            Query<Map<String, Object>> query = this.createCompletedTaskInfoQuery(handle, timestamp, maxNumStatuses, dataSource);
            return query.map(this.taskInfoMapper).list();
        });
    }

    @Override
    public List<TaskInfo<EntryType, StatusType>> getActiveTaskInfo(@Nullable String dataSource) {
        return this.getConnector().retryWithHandle(handle -> {
            Query<Map<String, Object>> query = this.createActiveTaskInfoQuery(handle, dataSource);
            return query.map(this.taskInfoMapper).list();
        });
    }

    private Query<Map<String, Object>> createActiveTaskInfoQuery(Handle handle, @Nullable String dataSource) {
        String sql = StringUtils.format("SELECT   id,   status_payload,   payload,   datasource,   created_date FROM   %s WHERE " + this.getWhereClauseForActiveStatusesQuery(dataSource) + "ORDER BY created_date", this.entryTable);
        Query query = handle.createQuery(sql);
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    private String getWhereClauseForActiveStatusesQuery(String dataSource) {
        String sql = StringUtils.format("active = TRUE ", new Object[0]);
        if (dataSource != null) {
            sql = sql + " AND datasource = :ds ";
        }
        return sql;
    }

    protected abstract Query<Map<String, Object>> createCompletedTaskInfoQuery(Handle var1, DateTime var2, @Nullable Integer var3, @Nullable String var4);

    @Override
    public boolean addLock(final String entryId, final LockType lock) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            @Override
            public Boolean withHandle(Handle handle) throws Exception {
                return SQLMetadataStorageActionHandler.this.addLock(handle, entryId, lock);
            }
        });
    }

    private boolean addLock(Handle handle, String entryId, LockType lock) throws JsonProcessingException {
        String statement = StringUtils.format("INSERT INTO %1$s (%2$s_id, lock_payload) VALUES (:entryId, :payload)", this.lockTable, this.entryTypeName);
        return ((Update)((Update)handle.createStatement(statement).bind("entryId", entryId)).bind("payload", this.jsonMapper.writeValueAsBytes(lock))).execute() == 1;
    }

    @Override
    public boolean replaceLock(String entryId, long oldLockId, LockType newLock) {
        return this.connector.retryTransaction((handle, transactionStatus) -> {
            int numDeletedRows = this.removeLock(handle, oldLockId);
            if (numDeletedRows != 1) {
                transactionStatus.setRollbackOnly();
                String message = numDeletedRows == 0 ? StringUtils.format("Cannot find lock[%d]", oldLockId) : StringUtils.format("Found multiple locks for lockId[%d]", oldLockId);
                throw new RuntimeException(message);
            }
            return this.addLock(handle, entryId, newLock);
        }, 3, 10);
    }

    @Override
    public void removeLock(final long lockId) {
        this.connector.retryWithHandle(new HandleCallback<Void>(){

            @Override
            public Void withHandle(Handle handle) {
                SQLMetadataStorageActionHandler.this.removeLock(handle, lockId);
                return null;
            }
        });
    }

    @Override
    public void removeTasksOlderThan(long timestamp) {
        DateTime dateTime = DateTimes.utc(timestamp);
        this.connector.retryWithHandle(handle -> {
            ((Update)handle.createStatement(this.getSqlRemoveLogsOlderThan()).bind("date_time", dateTime.toString())).execute();
            ((Update)handle.createStatement(StringUtils.format("DELETE FROM %s WHERE created_date < :date_time AND active = false", this.entryTable)).bind("date_time", dateTime.toString())).execute();
            return null;
        });
    }

    private int removeLock(Handle handle, long lockId) {
        return ((Update)handle.createStatement(StringUtils.format("DELETE FROM %s WHERE id = :id", this.lockTable)).bind("id", lockId)).execute();
    }

    @Override
    public boolean addLog(final String entryId, final LogType log) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            @Override
            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %1$s (%2$s_id, log_payload) VALUES (:entryId, :payload)", SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).bind("payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(log))).execute() == 1;
            }
        });
    }

    @Override
    public List<LogType> getLogs(final String entryId) {
        return (List)this.connector.retryWithHandle(new HandleCallback<List<LogType>>(){

            @Override
            public List<LogType> withHandle(Handle handle) {
                return ((Query)handle.createQuery(StringUtils.format("SELECT log_payload FROM %1$s WHERE %2$s_id = :entryId", SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).map(ByteArrayMapper.FIRST).fold(new ArrayList(), (list, bytes, control, ctx) -> {
                    try {
                        list.add(SQLMetadataStorageActionHandler.this.jsonMapper.readValue((byte[])bytes, SQLMetadataStorageActionHandler.this.logType));
                        return list;
                    }
                    catch (IOException e) {
                        log.makeAlert(e, "Failed to deserialize log", new Object[0]).addData("entryId", entryId).addData("payload", StringUtils.fromUtf8(bytes)).emit();
                        throw new SQLException(e);
                    }
                });
            }
        });
    }

    @Deprecated
    public String getSqlRemoveLogsOlderThan() {
        return StringUtils.format("DELETE a FROM %s a INNER JOIN %s b ON a.%s_id = b.id WHERE b.created_date < :date_time and b.active = false", this.logTable, this.entryTable, this.entryTypeName);
    }

    @Override
    public Map<Long, LockType> getLocks(final String entryId) {
        return (Map)this.connector.retryWithHandle(new HandleCallback<Map<Long, LockType>>(){

            @Override
            public Map<Long, LockType> withHandle(Handle handle) {
                return ((Query)handle.createQuery(StringUtils.format("SELECT id, lock_payload FROM %1$s WHERE %2$s_id = :entryId", SQLMetadataStorageActionHandler.this.lockTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).map(new ResultSetMapper<Pair<Long, LockType>>(){

                    @Override
                    public Pair<Long, LockType> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of(r.getLong("id"), SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("lock_payload"), SQLMetadataStorageActionHandler.this.lockType));
                        }
                        catch (IOException e) {
                            log.makeAlert(e, "Failed to deserialize " + SQLMetadataStorageActionHandler.this.lockType.getType(), new Object[0]).addData("id", r.getLong("id")).addData("lockPayload", StringUtils.fromUtf8(r.getBytes("lock_payload"))).emit();
                            throw new SQLException(e);
                        }
                    }
                }).fold(Maps.newLinkedHashMap(), new Folder3<Map<Long, LockType>, Pair<Long, LockType>>(){

                    @Override
                    public Map<Long, LockType> fold(Map<Long, LockType> accumulator, Pair<Long, LockType> lock, FoldController control, StatementContext ctx) {
                        accumulator.put((Long)lock.lhs, (Object)lock.rhs);
                        return accumulator;
                    }
                });
            }
        });
    }

    @Override
    @Nullable
    public Long getLockId(String entryId, LockType lock) {
        return this.getLocks(entryId).entrySet().stream().filter(entry -> entry.getValue().equals(lock)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    static class TaskInfoMapper<EntryType, StatusType>
    implements ResultSetMapper<TaskInfo<EntryType, StatusType>> {
        private final ObjectMapper objectMapper;
        private final TypeReference<EntryType> entryType;
        private final TypeReference<StatusType> statusType;

        TaskInfoMapper(ObjectMapper objectMapper, TypeReference<EntryType> entryType, TypeReference<StatusType> statusType) {
            this.objectMapper = objectMapper;
            this.entryType = entryType;
            this.statusType = statusType;
        }

        @Override
        public TaskInfo<EntryType, StatusType> map(int index, ResultSet resultSet, StatementContext context) throws SQLException {
            StatusType status;
            EntryType task;
            try {
                task = this.objectMapper.readValue(resultSet.getBytes("payload"), this.entryType);
            }
            catch (IOException e) {
                log.warn("Encountered exception[%s] while deserializing task payload, setting payload to null", e.getMessage());
                task = null;
            }
            try {
                status = this.objectMapper.readValue(resultSet.getBytes("status_payload"), this.statusType);
            }
            catch (IOException e) {
                log.error(e, "Encountered exception while deserializing task status_payload", new Object[0]);
                throw new SQLException(e);
            }
            TaskInfo<EntryType, StatusType> taskInfo = new TaskInfo<EntryType, StatusType>(resultSet.getString("id"), DateTimes.of(resultSet.getString("created_date")), status, resultSet.getString("datasource"), task);
            return taskInfo;
        }
    }
}

