/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import com.google.inject.Inject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.audit.AuditEntry;
import org.apache.hive.druid.org.apache.druid.audit.AuditInfo;
import org.apache.hive.druid.org.apache.druid.audit.AuditManager;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataRuleManagerConfig;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@ManageLifecycle
public class SQLMetadataRuleManager
implements MetadataRuleManager {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataRuleManager.class);
    private final ObjectMapper jsonMapper;
    private final MetadataRuleManagerConfig config;
    private final MetadataStorageTablesConfig dbTables;
    private final IDBI dbi;
    private final AtomicReference<ImmutableMap<String, List<Rule>>> rules;
    private final AuditManager auditManager;
    private final Object lock = new Object();
    private long startCount = 0L;
    private long currentStartOrder = -1L;
    private ScheduledExecutorService exec = null;
    private long failStartTimeMs = 0L;

    public static void createDefaultRule(IDBI dbi, final String ruleTable, final String defaultDatasourceName, final ObjectMapper jsonMapper) {
        try {
            dbi.withHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    List existing = ((Query)handle.createQuery(StringUtils.format("SELECT id from %s where datasource=:dataSource", ruleTable)).bind("dataSource", defaultDatasourceName)).list();
                    if (!existing.isEmpty()) {
                        return null;
                    }
                    List<ForeverLoadRule> defaultRules = Collections.singletonList(new ForeverLoadRule(ImmutableMap.of("_default_tier", 2)));
                    String version = DateTimes.nowUtc().toString();
                    ((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %s (id, dataSource, version, payload) VALUES (:id, :dataSource, :version, :payload)", ruleTable)).bind("id", StringUtils.format("%s_%s", defaultDatasourceName, version))).bind("dataSource", defaultDatasourceName)).bind("version", version)).bind("payload", jsonMapper.writeValueAsBytes(defaultRules))).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    public SQLMetadataRuleManager(@Json ObjectMapper jsonMapper, MetadataRuleManagerConfig config, MetadataStorageTablesConfig dbTables, SQLMetadataConnector connector, AuditManager auditManager) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dbi = connector.getDBI();
        this.auditManager = auditManager;
        Preconditions.checkNotNull(config.getAlertThreshold().toStandardDuration());
        Preconditions.checkNotNull(config.getPollDuration().toStandardDuration());
        this.rules = new AtomicReference(ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentStartOrder >= 0L) {
                return;
            }
            ++this.startCount;
            final long localStartedOrder = this.currentStartOrder = this.startCount;
            this.exec = Execs.scheduledSingleThreaded("DatabaseRuleManager-Exec--%d");
            SQLMetadataRuleManager.createDefaultRule(this.dbi, this.getRulesTable(), this.config.getDefaultRule(), this.jsonMapper);
            this.exec.scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = SQLMetadataRuleManager.this.lock;
                        synchronized (object) {
                            if (localStartedOrder == SQLMetadataRuleManager.this.currentStartOrder) {
                                SQLMetadataRuleManager.this.poll();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error(e, "uncaught exception in rule manager polling thread", new Object[0]);
                    }
                }
            }, 0L, this.config.getPollDuration().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentStartOrder == -1L) {
                return;
            }
            this.rules.set(ImmutableMap.of());
            this.currentStartOrder = -1L;
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    @Override
    public void poll() {
        try {
            ImmutableMap<String, List<Rule>> newRules = ImmutableMap.copyOf(this.dbi.withHandle(new HandleCallback<Map<String, List<Rule>>>(){

                @Override
                public Map<String, List<Rule>> withHandle(Handle handle) {
                    return handle.createQuery(StringUtils.format("SELECT r.dataSource, r.payload FROM %1$s r INNER JOIN(SELECT dataSource, max(version) as version FROM %1$s GROUP BY dataSource) ds ON r.datasource = ds.datasource and r.version = ds.version", SQLMetadataRuleManager.this.getRulesTable())).map(new ResultSetMapper<Pair<String, List<Rule>>>(){

                        @Override
                        public Pair<String, List<Rule>> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                            try {
                                return Pair.of(r.getString("dataSource"), SQLMetadataRuleManager.this.jsonMapper.readValue(r.getBytes("payload"), new TypeReference<List<Rule>>(){}));
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }).fold(new HashMap(), new Folder3<Map<String, List<Rule>>, Pair<String, List<Rule>>>(){

                        @Override
                        public Map<String, List<Rule>> fold(Map<String, List<Rule>> retVal, Pair<String, List<Rule>> stringObjectMap, FoldController foldController, StatementContext statementContext) {
                            try {
                                String dataSource = (String)stringObjectMap.lhs;
                                retVal.put(dataSource, (List<Rule>)stringObjectMap.rhs);
                                return retVal;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            }));
            int newRuleCount = newRules.values().stream().mapToInt(List::size).sum();
            log.info("Polled and found %,d rule(s) for %,d datasource(s)", newRuleCount, newRules.size());
            this.rules.set(newRules);
            this.failStartTimeMs = 0L;
        }
        catch (Exception e) {
            if (this.failStartTimeMs == 0L) {
                this.failStartTimeMs = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.failStartTimeMs > this.config.getAlertThreshold().toStandardDuration().getMillis()) {
                log.makeAlert(e, "Exception while polling for rules", new Object[0]).emit();
                this.failStartTimeMs = 0L;
            }
            log.error(e, "Exception while polling for rules", new Object[0]);
        }
    }

    @Override
    public Map<String, List<Rule>> getAllRules() {
        return this.rules.get();
    }

    @Override
    public List<Rule> getRules(String dataSource) {
        ArrayList retVal = this.rules.get().get(dataSource);
        return retVal == null ? new ArrayList() : retVal;
    }

    @Override
    public List<Rule> getRulesWithDefault(String dataSource) {
        ArrayList<Rule> retVal = new ArrayList<Rule>();
        Map theRules = this.rules.get();
        if (theRules.get(dataSource) != null) {
            retVal.addAll((Collection)theRules.get(dataSource));
        }
        if (theRules.get(this.config.getDefaultRule()) != null) {
            retVal.addAll((Collection)theRules.get(this.config.getDefaultRule()));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean overrideRule(final String dataSource, final List<Rule> newRules, final AuditInfo auditInfo) {
        String ruleString;
        try {
            ruleString = this.jsonMapper.writeValueAsString(newRules);
            log.info("Updating [%s] with rules [%s] as per [%s]", dataSource, ruleString, auditInfo);
        }
        catch (JsonProcessingException e) {
            log.error(e, "Unable to write rules as string for [%s]", dataSource);
            return false;
        }
        Object e = this.lock;
        synchronized (e) {
            try {
                this.dbi.inTransaction(new TransactionCallback<Void>(){

                    @Override
                    public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                        DateTime auditTime = DateTimes.nowUtc();
                        SQLMetadataRuleManager.this.auditManager.doAudit(AuditEntry.builder().key(dataSource).type("rules").auditInfo(auditInfo).payload(ruleString).auditTime(auditTime).build(), handle);
                        String version = auditTime.toString();
                        ((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %s (id, dataSource, version, payload) VALUES (:id, :dataSource, :version, :payload)", SQLMetadataRuleManager.this.getRulesTable())).bind("id", StringUtils.format("%s_%s", dataSource, version))).bind("dataSource", dataSource)).bind("version", version)).bind("payload", SQLMetadataRuleManager.this.jsonMapper.writeValueAsBytes(newRules))).execute();
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                log.error(e2, StringUtils.format("Exception while overriding rule for %s", dataSource), new Object[0]);
                return false;
            }
        }
        try {
            this.poll();
        }
        catch (Exception e2) {
            log.error(e2, StringUtils.format("Exception while polling for rules after overriding the rule for %s", dataSource), new Object[0]);
        }
        return true;
    }

    private String getRulesTable() {
        return this.dbTables.getRulesTable();
    }
}

