/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.math.expr.ApplyFunction;
import org.apache.hive.druid.org.apache.druid.math.expr.ApplyFunctionExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.hive.druid.org.apache.druid.math.expr.ConstantExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.Evals;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprListenerImpl;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.math.expr.Function;
import org.apache.hive.druid.org.apache.druid.math.expr.FunctionExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.IdentifierExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.LambdaExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.UnaryExpr;
import org.apache.hive.druid.org.apache.druid.math.expr.antlr.ExprLexer;
import org.apache.hive.druid.org.apache.druid.math.expr.antlr.ExprParser;

public class Parser {
    private static final Logger log = new Logger(Parser.class);
    private static final Map<String, Function> FUNCTIONS;
    private static final Map<String, ApplyFunction> APPLY_FUNCTIONS;

    public static Function getFunction(String name) {
        return FUNCTIONS.get(StringUtils.toLowerCase(name));
    }

    public static ApplyFunction getApplyFunction(String name) {
        return APPLY_FUNCTIONS.get(StringUtils.toLowerCase(name));
    }

    public static Expr parse(String in, ExprMacroTable macroTable) {
        return Parser.parse(in, macroTable, true);
    }

    @VisibleForTesting
    static Expr parse(String in, ExprMacroTable macroTable, boolean withFlatten) {
        ExprLexer lexer = new ExprLexer(new ANTLRInputStream(in));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ExprParser parser = new ExprParser(tokens);
        parser.setBuildParseTree(true);
        ExprParser.ExprContext parseTree = parser.expr();
        ParseTreeWalker walker = new ParseTreeWalker();
        ExprListenerImpl listener = new ExprListenerImpl(parseTree, macroTable);
        walker.walk(listener, parseTree);
        return withFlatten ? Parser.flatten(listener.getAST()) : listener.getAST();
    }

    public static Expr flatten(Expr expr) {
        return expr.visit(childExpr -> {
            if (childExpr instanceof BinaryOpExprBase) {
                BinaryOpExprBase binary = (BinaryOpExprBase)childExpr;
                if (Evals.isAllConstants(binary.left, binary.right)) {
                    return childExpr.eval(null).toExpr();
                }
            } else if (childExpr instanceof UnaryExpr) {
                UnaryExpr unary = (UnaryExpr)childExpr;
                if (unary.expr instanceof ConstantExpr) {
                    return childExpr.eval(null).toExpr();
                }
            } else if (childExpr instanceof FunctionExpr) {
                FunctionExpr functionExpr = (FunctionExpr)childExpr;
                ImmutableList<Expr> args = functionExpr.args;
                if (Evals.isAllConstants(args)) {
                    return childExpr.eval(null).toExpr();
                }
            } else if (childExpr instanceof ApplyFunctionExpr) {
                ApplyFunctionExpr applyFunctionExpr = (ApplyFunctionExpr)childExpr;
                ImmutableList<Expr> args = applyFunctionExpr.argsExpr;
                if (Evals.isAllConstants(args) && applyFunctionExpr.analyzeInputs().getFreeVariables().size() == 0) {
                    return childExpr.eval(null).toExpr();
                }
            }
            return childExpr;
        });
    }

    public static Expr applyUnappliedBindings(Expr expr, Expr.BindingDetails bindingDetails, List<String> bindingsToApply) {
        if (bindingsToApply.isEmpty()) {
            return expr;
        }
        List unappliedBindingsInExpression = bindingsToApply.stream().filter(x -> bindingDetails.getRequiredBindings().contains(x)).collect(Collectors.toList());
        Expr newExpr = expr.visit(childExpr -> {
            if (childExpr instanceof ApplyFunctionExpr) {
                return Parser.liftApplyLambda((ApplyFunctionExpr)childExpr, unappliedBindingsInExpression);
            }
            if (childExpr instanceof FunctionExpr) {
                FunctionExpr fnExpr = (FunctionExpr)childExpr;
                Set<Expr> arrayInputs = fnExpr.function.getArrayInputs(fnExpr.args);
                ArrayList<Expr> newArgs = new ArrayList<Expr>();
                for (Expr arg : fnExpr.args) {
                    if (arg.getIdentifierIfIdentifier() == null && arrayInputs.contains(arg)) {
                        Expr newArg = Parser.applyUnappliedBindings(arg, bindingDetails, unappliedBindingsInExpression);
                        newArgs.add(newArg);
                        continue;
                    }
                    newArgs.add(arg);
                }
                FunctionExpr newFnExpr = new FunctionExpr(fnExpr.function, fnExpr.function.name(), newArgs);
                return newFnExpr;
            }
            return childExpr;
        });
        Expr.BindingDetails newExprBindings = newExpr.analyzeInputs();
        Set<String> expectedArrays = newExprBindings.getArrayVariables();
        List<String> remainingUnappliedBindings = unappliedBindingsInExpression.stream().filter(x -> !expectedArrays.contains(x)).collect(Collectors.toList());
        if (remainingUnappliedBindings.isEmpty()) {
            return newExpr;
        }
        return Parser.applyUnapplied(newExpr, remainingUnappliedBindings);
    }

    private static Expr applyUnapplied(Expr expr, List<String> unappliedBindings) {
        List args = expr.analyzeInputs().getFreeVariables().stream().filter(x -> unappliedBindings.contains(x.getBinding())).collect(Collectors.toList());
        ArrayList<IdentifierExpr> lambdaArgs = new ArrayList<IdentifierExpr>();
        HashMap<String, IdentifierExpr> toReplace = new HashMap<String, IdentifierExpr>();
        for (IdentifierExpr applyFnArg : args) {
            if (toReplace.containsKey(applyFnArg.getBinding())) continue;
            IdentifierExpr lambdaRewrite = new IdentifierExpr(applyFnArg.getBinding());
            lambdaArgs.add(lambdaRewrite);
            toReplace.put(applyFnArg.getBinding(), lambdaRewrite);
        }
        Expr newExpr = expr.visit(childExpr -> {
            if (childExpr instanceof IdentifierExpr && toReplace.containsKey(((IdentifierExpr)childExpr).getBinding())) {
                return (Expr)toReplace.get(((IdentifierExpr)childExpr).getBinding());
            }
            return childExpr;
        });
        LambdaExpr lambdaExpr = new LambdaExpr(lambdaArgs, newExpr);
        ApplyFunction.BaseMapFunction fn = lambdaArgs.size() == 1 ? new ApplyFunction.MapFunction() : new ApplyFunction.CartesianMapFunction();
        ApplyFunctionExpr magic = new ApplyFunctionExpr(fn, fn.name(), lambdaExpr, ImmutableList.copyOf(lambdaArgs));
        return magic;
    }

    private static ApplyFunctionExpr liftApplyLambda(ApplyFunctionExpr expr, List<String> unappliedArgs) {
        ApplyFunctionExpr newExpr;
        Set unappliedInThisApply = unappliedArgs.stream().filter(u -> !expr.bindingDetails.getArrayBindings().contains(u)).collect(Collectors.toSet());
        List<String> unappliedIdentifiers = expr.bindingDetails.getFreeVariables().stream().filter(x -> unappliedInThisApply.contains(x.getBindingIfIdentifier())).map(IdentifierExpr::getIdentifierIfIdentifier).collect(Collectors.toList());
        ArrayList<Expr> newArgs = new ArrayList<Expr>();
        for (int i = 0; i < expr.argsExpr.size(); ++i) {
            newArgs.add(Parser.applyUnappliedBindings((Expr)expr.argsExpr.get(i), (Expr.BindingDetails)expr.argsBindingDetails.get(i), unappliedIdentifiers));
        }
        List unappliedLambdaBindings = expr.lambdaBindingDetails.getFreeVariables().stream().filter(x -> unappliedArgs.contains(x.getBindingIfIdentifier())).map(x -> new IdentifierExpr(x.getIdentifier(), x.getBinding())).collect(Collectors.toList());
        if (unappliedLambdaBindings.isEmpty()) {
            return new ApplyFunctionExpr(expr.function, expr.name, expr.lambdaExpr, newArgs);
        }
        newArgs.addAll(unappliedLambdaBindings);
        switch (expr.function.name()) {
            case "map": 
            case "cartesian_map": {
                ArrayList<IdentifierExpr> lambdaIds = new ArrayList<IdentifierExpr>(expr.lambdaExpr.getIdentifiers().size() + unappliedArgs.size());
                lambdaIds.addAll(expr.lambdaExpr.getIdentifierExprs());
                lambdaIds.addAll(unappliedLambdaBindings);
                LambdaExpr newLambda = new LambdaExpr(lambdaIds, expr.lambdaExpr.getExpr());
                ApplyFunction.CartesianMapFunction newFn = new ApplyFunction.CartesianMapFunction();
                newExpr = new ApplyFunctionExpr(newFn, newFn.name(), newLambda, newArgs);
                break;
            }
            case "all": 
            case "any": 
            case "filter": {
                ApplyFunction.CartesianMapFunction newArrayFn = new ApplyFunction.CartesianMapFunction();
                IdentifierExpr identityExprIdentifier = new IdentifierExpr("_");
                LambdaExpr identityExpr = new LambdaExpr(ImmutableList.of(identityExprIdentifier), identityExprIdentifier);
                ApplyFunctionExpr arrayExpr = new ApplyFunctionExpr(newArrayFn, newArrayFn.name(), identityExpr, newArgs);
                newExpr = new ApplyFunctionExpr(expr.function, expr.function.name(), identityExpr, ImmutableList.of(arrayExpr));
                break;
            }
            case "fold": 
            case "cartesian_fold": {
                ArrayList<Expr> newFoldArgs = new ArrayList<Expr>(expr.argsExpr.size() + unappliedLambdaBindings.size());
                ArrayList<IdentifierExpr> newFoldLambdaIdentifiers = new ArrayList<IdentifierExpr>(expr.lambdaExpr.getIdentifiers().size() + unappliedLambdaBindings.size());
                ImmutableList<IdentifierExpr> existingFoldLambdaIdentifiers = expr.lambdaExpr.getIdentifierExprs();
                for (int i = 0; i < expr.argsExpr.size() - 1; ++i) {
                    newFoldArgs.add((Expr)expr.argsExpr.get(i));
                    newFoldLambdaIdentifiers.add((IdentifierExpr)existingFoldLambdaIdentifiers.get(i));
                }
                newFoldArgs.addAll(unappliedLambdaBindings);
                newFoldLambdaIdentifiers.addAll(unappliedLambdaBindings);
                newFoldLambdaIdentifiers.add((IdentifierExpr)existingFoldLambdaIdentifiers.get(existingFoldLambdaIdentifiers.size() - 1));
                newFoldArgs.add((Expr)expr.argsExpr.get(expr.argsExpr.size() - 1));
                LambdaExpr newFoldLambda = new LambdaExpr(newFoldLambdaIdentifiers, expr.lambdaExpr.getExpr());
                ApplyFunction.CartesianFoldFunction newFn = new ApplyFunction.CartesianFoldFunction();
                newExpr = new ApplyFunctionExpr(newFn, newFn.name(), newFoldLambda, newFoldArgs);
                break;
            }
            default: {
                throw new RE("Unable to transform apply function:[%s]", expr.function.name());
            }
        }
        return newExpr;
    }

    public static void validateExpr(Expr expression, Expr.BindingDetails bindingDetails) {
        Sets.SetView<String> conflicted = Sets.intersection(bindingDetails.getScalarBindings(), bindingDetails.getArrayBindings());
        if (!conflicted.isEmpty()) {
            throw new RE("Invalid expression: %s; %s used as both scalar and array variables", expression, conflicted);
        }
    }

    public static Expr.ObjectBinding withMap(Map<String, ?> bindings) {
        return bindings::get;
    }

    public static Expr.ObjectBinding withSuppliers(Map<String, Supplier<Object>> bindings) {
        return name -> {
            Supplier supplier = (Supplier)bindings.get(name);
            return supplier == null ? null : supplier.get();
        };
    }

    static {
        HashMap<String, Function> functionMap = new HashMap<String, Function>();
        for (Class<?> clazz : Function.class.getClasses()) {
            if (Modifier.isAbstract(clazz.getModifiers()) || !Function.class.isAssignableFrom(clazz)) continue;
            try {
                Function function = (Function)clazz.newInstance();
                functionMap.put(StringUtils.toLowerCase(function.name()), function);
            }
            catch (Exception e) {
                log.error(e, "failed to instantiate %s.. ignoring", clazz.getName());
            }
        }
        FUNCTIONS = ImmutableMap.copyOf(functionMap);
        HashMap<String, ApplyFunction> applyFunctionMap = new HashMap<String, ApplyFunction>();
        for (Class<?> clazz : ApplyFunction.class.getClasses()) {
            if (Modifier.isAbstract(clazz.getModifiers()) || !ApplyFunction.class.isAssignableFrom(clazz)) continue;
            try {
                ApplyFunction function = (ApplyFunction)clazz.newInstance();
                applyFunctionMap.put(StringUtils.toLowerCase(function.name()), function);
            }
            catch (Exception e) {
                log.error(e, "failed to instantiate %s.. ignoring", clazz.getName());
            }
        }
        APPLY_FUNCTIONS = ImmutableMap.copyOf(applyFunctionMap);
    }
}

