/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;

public class ExprMacroTable {
    private static final ExprMacroTable NIL = new ExprMacroTable(Collections.emptyList());
    private final Map<String, ExprMacro> macroMap;

    public ExprMacroTable(List<ExprMacro> macros) {
        this.macroMap = macros.stream().collect(Collectors.toMap(m -> StringUtils.toLowerCase(m.name()), m -> m));
    }

    public static ExprMacroTable nil() {
        return NIL;
    }

    public List<ExprMacro> getMacros() {
        return ImmutableList.copyOf(this.macroMap.values());
    }

    @Nullable
    public Expr get(String functionName, List<Expr> args) {
        ExprMacro exprMacro = this.macroMap.get(StringUtils.toLowerCase(functionName));
        if (exprMacro == null) {
            return null;
        }
        return exprMacro.apply(args);
    }

    public static abstract class BaseScalarMacroFunctionExpr
    implements Expr {
        protected final List<Expr> args;
        private final Supplier<Expr.BindingDetails> analyzeInputsSupplier;

        public BaseScalarMacroFunctionExpr(List<Expr> args) {
            this.args = args;
            this.analyzeInputsSupplier = Suppliers.memoize(this::supplyAnalyzeInputs);
        }

        @Override
        public void visit(Expr.Visitor visitor) {
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
            visitor.visit(this);
        }

        @Override
        public Expr.BindingDetails analyzeInputs() {
            return this.analyzeInputsSupplier.get();
        }

        private Expr.BindingDetails supplyAnalyzeInputs() {
            HashSet<Expr> argSet = new HashSet<Expr>(this.args.size());
            Expr.BindingDetails accumulator = new Expr.BindingDetails();
            for (Expr arg : this.args) {
                accumulator = accumulator.with(arg);
                argSet.add(arg);
            }
            return accumulator.withScalarArguments(argSet);
        }
    }

    public static abstract class BaseScalarUnivariateMacroFunctionExpr
    implements Expr {
        protected final Expr arg;
        private final Supplier<Expr.BindingDetails> analyzeInputsSupplier;

        public BaseScalarUnivariateMacroFunctionExpr(Expr arg) {
            this.arg = arg;
            this.analyzeInputsSupplier = Suppliers.memoize(this::supplyAnalyzeInputs);
        }

        @Override
        public void visit(Expr.Visitor visitor) {
            this.arg.visit(visitor);
            visitor.visit(this);
        }

        @Override
        public Expr.BindingDetails analyzeInputs() {
            return this.analyzeInputsSupplier.get();
        }

        private Expr.BindingDetails supplyAnalyzeInputs() {
            return this.arg.analyzeInputs().withScalarArguments(ImmutableSet.of(this.arg));
        }
    }

    public static interface ExprMacro {
        public String name();

        public Expr apply(List<Expr> var1);
    }
}

