/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.emitter.core;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.primitives.UnsignedInts;

public class ConcurrentTimeCounter {
    private final AtomicLong timeSumAndCount = new AtomicLong(0L);
    private final AtomicLong max = new AtomicLong(-1L);
    private final AtomicLong min = new AtomicLong(-1L);

    public void add(int time) {
        long x = 0x100000000L | (long)time;
        this.timeSumAndCount.addAndGet(x);
        this.updateMax(time);
        this.updateMin(time);
    }

    private void updateMax(int time) {
        long max;
        do {
            if ((max = this.max.get()) < 0L || (int)max < time) continue;
            return;
        } while (!this.max.compareAndSet(max, UnsignedInts.toLong(time)));
    }

    private void updateMin(int time) {
        long min;
        do {
            if ((min = this.min.get()) < 0L || (int)min > time) continue;
            return;
        } while (!this.min.compareAndSet(min, UnsignedInts.toLong(time)));
    }

    @VisibleForTesting
    long getTimeSumAndCount() {
        return this.timeSumAndCount.get();
    }

    public long getTimeSumAndCountAndReset() {
        return this.timeSumAndCount.getAndSet(0L);
    }

    @Nullable
    public Integer getAndResetMaxTime() {
        long max = this.max.getAndSet(-1L);
        if (max >= 0L) {
            return (int)max;
        }
        return null;
    }

    @Nullable
    public Integer getAndResetMinTime() {
        long min = this.min.getAndSet(-1L);
        if (min >= 0L) {
            return (int)min;
        }
        return null;
    }

    public static int timeSum(long timeSumAndCount) {
        return (int)timeSumAndCount;
    }

    public static int count(long timeSumAndCount) {
        return (int)(timeSumAndCount >> 32);
    }
}

