/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.parsers;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.AbstractFlatTextFormatParser;

public class DelimitedParser
extends AbstractFlatTextFormatParser {
    private final Splitter splitter;

    public DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, boolean hasHeaderRow, int maxSkipHeaderRows) {
        super(listDelimiter, hasHeaderRow, maxSkipHeaderRows);
        String finalDelimiter = delimiter != null ? delimiter : AbstractFlatTextFormatParser.FlatTextFormat.DELIMITED.getDefaultDelimiter();
        Preconditions.checkState(!finalDelimiter.equals(this.getListDelimiter()), "Cannot have same delimiter and list delimiter of [%s]", finalDelimiter);
        this.splitter = Splitter.on(finalDelimiter);
    }

    public DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, Iterable<String> fieldNames, boolean hasHeaderRow, int maxSkipHeaderRows) {
        this(delimiter, listDelimiter, hasHeaderRow, maxSkipHeaderRows);
        this.setFieldNames(fieldNames);
    }

    @VisibleForTesting
    DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, String header) {
        this(delimiter, listDelimiter, false, 0);
        this.setFieldNames(header);
    }

    @Override
    protected List<String> parseLine(String input) {
        return this.splitToList(input);
    }

    private List<String> splitToList(String input) {
        return DelimitedInputFormat.splitToList(this.splitter, input);
    }
}

