/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.logger;

import java.util.function.BiConsumer;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.slf4j.LoggerFactory;

public class Logger {
    private final org.slf4j.Logger log;
    private final boolean stackTraces;
    private final Logger noStackTraceLogger;

    public Logger(String name) {
        this(LoggerFactory.getLogger((String)name), true);
    }

    public Logger(Class clazz) {
        this(LoggerFactory.getLogger((Class)clazz), true);
    }

    protected Logger(org.slf4j.Logger log, boolean stackTraces) {
        this.log = log;
        this.stackTraces = stackTraces;
        this.noStackTraceLogger = stackTraces ? new Logger(log, false) : this;
    }

    protected org.slf4j.Logger getSlf4jLogger() {
        return this.log;
    }

    public String toString() {
        return StringUtils.format("Logger{name=[%s], class[%s]}", this.log.getName(), this.log.getClass());
    }

    public Logger noStackTrace() {
        return this.noStackTraceLogger;
    }

    public void trace(String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void debug(String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void debug(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).debug(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void info(String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void info(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).info(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    @Deprecated
    public void warn(String message, Throwable t) {
        this.warn(t, message, new Object[0]);
    }

    public void warn(String message, Object ... formatArgs) {
        this.log.warn(StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void warn(Throwable t, String message, Object ... formatArgs) {
        this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).warn(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void error(String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat(message, formatArgs));
    }

    @Deprecated
    public void error(String message, Throwable t) {
        this.error(t, message, new Object[0]);
    }

    public void error(Throwable t, String message, Object ... formatArgs) {
        this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).error(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void assertionError(String message, Object ... formatArgs) {
        this.log.error("ASSERTION_ERROR: " + message, formatArgs);
    }

    public void wtf(String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat("WTF?!: " + message, formatArgs), (Throwable)new Exception());
    }

    public void wtf(Throwable t, String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat("WTF?!: " + message, formatArgs), t);
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    private void logException(BiConsumer<String, Throwable> fn, Throwable t, String message) {
        if (this.stackTraces || this.log.isDebugEnabled()) {
            fn.accept(message, t);
        } else if (message.isEmpty()) {
            fn.accept(t.toString(), null);
        } else {
            fn.accept(StringUtils.nonStrictFormat("%s (%s)", message, t.toString()), null);
        }
    }
}

