/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.DroppingIterable;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.nary.TrinaryFn;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.nary.TrinaryTransformIterable;

public class FunctionalIterable<T>
implements Iterable<T> {
    private final Iterable<T> delegate;

    public static <T> FunctionalIterable<T> create(Iterable<T> delegate) {
        return new FunctionalIterable<T>(delegate);
    }

    public FunctionalIterable(Iterable<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public <RetType> FunctionalIterable<RetType> transform(Function<T, RetType> fn) {
        return new FunctionalIterable<RetType>(Iterables.transform(this.delegate, fn));
    }

    public <RetType> FunctionalIterable<RetType> transformCat(Function<T, Iterable<RetType>> fn) {
        return new FunctionalIterable<RetType>(Iterables.concat(Iterables.transform(this.delegate, fn)));
    }

    public <RetType> FunctionalIterable<RetType> keep(Function<T, RetType> fn) {
        return new FunctionalIterable<RetType>(Iterables.filter(Iterables.transform(this.delegate, fn), Predicates.notNull()));
    }

    public FunctionalIterable<T> filter(Predicate<T> pred) {
        return new FunctionalIterable<T>(Iterables.filter(this.delegate, pred));
    }

    public FunctionalIterable<T> drop(int numToDrop) {
        return new FunctionalIterable<T>(new DroppingIterable<T>(this.delegate, numToDrop));
    }

    public FunctionalIterable<T> limit(int limit) {
        return new FunctionalIterable<T>(Iterables.limit(this.delegate, limit));
    }

    public <InType1, InType2, RetType> FunctionalIterable<RetType> trinaryTransform(Iterable<InType1> iterable1, Iterable<InType2> iterable2, TrinaryFn<T, InType1, InType2, RetType> trinaryFn) {
        return new FunctionalIterable<T>(TrinaryTransformIterable.create(this.delegate, iterable1, iterable2, trinaryFn));
    }
}

