/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.com.google.common.primitives.Floats;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;

public final class Numbers {
    public static long parseLong(Object val) {
        if (val instanceof String) {
            return Long.parseLong((String)val);
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val == null) {
            throw new NullPointerException("Input is null");
        }
        throw new ISE("Unknown type [%s]", val.getClass());
    }

    public static int parseInt(Object val) {
        if (val instanceof String) {
            return Integer.parseInt((String)val);
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val == null) {
            throw new NullPointerException("Input is null");
        }
        throw new ISE("Unknown type [%s]", val.getClass());
    }

    public static boolean parseBoolean(Object val) {
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val == null) {
            throw new NullPointerException("Input is null");
        }
        throw new ISE("Unknown type [%s]", val.getClass());
    }

    public static double tryParseDouble(@Nullable Object val, double nullValue) {
        if (val == null) {
            return nullValue;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof String) {
            Double d = Doubles.tryParse((String)val);
            return d == null ? nullValue : d;
        }
        throw new IAE("Unknown object type [%s]", val.getClass().getName());
    }

    public static long tryParseLong(@Nullable Object val, long nullValue) {
        if (val == null) {
            return nullValue;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            long l = nullValue;
            Long lobj = Longs.tryParse((String)val);
            if (lobj == null) {
                Double dobj = Doubles.tryParse((String)val);
                if (dobj != null) {
                    l = dobj.longValue();
                }
            } else {
                l = lobj;
            }
            return l;
        }
        throw new IAE("Unknown object type [%s]", val.getClass().getName());
    }

    public static float tryParseFloat(@Nullable Object val, float nullValue) {
        if (val == null) {
            return nullValue;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        if (val instanceof String) {
            Float f = Floats.tryParse((String)val);
            return f == null ? nullValue : f.floatValue();
        }
        throw new IAE("Unknown object type [%s]", val.getClass().getName());
    }

    public static int toIntExact(long value, String error) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException(error);
        }
        return (int)value;
    }

    private Numbers() {
    }
}

