/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.inputsource.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.data.input.RetryingInputEntity;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPuller;

public class HdfsInputEntity
extends RetryingInputEntity {
    private final Configuration conf;
    private final Path path;

    HdfsInputEntity(Configuration conf, Path path) {
        this.conf = conf;
        this.path = path;
    }

    @Override
    public URI getUri() {
        return this.path.toUri();
    }

    @Override
    protected InputStream readFrom(long offset) throws IOException {
        FileSystem fs = this.path.getFileSystem(this.conf);
        FSDataInputStream inputStream = fs.open(this.path);
        inputStream.seek(offset);
        return inputStream;
    }

    @Override
    protected String getPath() {
        return this.path.getName();
    }

    @Override
    public Predicate<Throwable> getRetryCondition() {
        return HdfsDataSegmentPuller.RETRY_PREDICATE;
    }
}

