/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexing.overlord.supervisor;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.indexer.TaskState;
import org.apache.hive.druid.org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;

public class SupervisorStateManager {
    private final SupervisorStateManagerConfig supervisorStateManagerConfig;
    private final State healthySteadyState;
    private final Deque<ExceptionEvent> recentEventsQueue = new ConcurrentLinkedDeque<ExceptionEvent>();
    private State supervisorState = BasicState.PENDING;
    private boolean atLeastOneSuccessfulRun = false;
    private boolean currentRunSuccessful = true;
    private boolean hasHitUnhealthinessThreshold = false;
    private boolean hasHitTaskUnhealthinessThreshold = false;
    private int consecutiveFailedRuns = 0;
    private int consecutiveSuccessfulRuns = 0;
    private int consecutiveFailedTasks = 0;
    private int consecutiveSuccessfulTasks = 0;

    public SupervisorStateManager(SupervisorStateManagerConfig supervisorStateManagerConfig, boolean suspended) {
        Preconditions.checkArgument(supervisorStateManagerConfig.getMaxStoredExceptionEvents() >= Math.max(supervisorStateManagerConfig.getHealthinessThreshold(), supervisorStateManagerConfig.getUnhealthinessThreshold()), "maxStoredExceptionEvents must be >= to max(healthinessThreshold, unhealthinessThreshold)");
        this.supervisorStateManagerConfig = supervisorStateManagerConfig;
        this.healthySteadyState = suspended ? BasicState.SUSPENDED : BasicState.RUNNING;
    }

    public void maybeSetState(State proposedState) {
        if (this.consecutiveFailedRuns >= this.supervisorStateManagerConfig.getUnhealthinessThreshold()) {
            this.hasHitUnhealthinessThreshold = true;
            this.supervisorState = this.getSpecificUnhealthySupervisorState();
            return;
        }
        if (this.consecutiveFailedTasks >= this.supervisorStateManagerConfig.getTaskUnhealthinessThreshold()) {
            this.hasHitTaskUnhealthinessThreshold = true;
            this.supervisorState = BasicState.UNHEALTHY_TASKS;
            return;
        }
        if (!this.supervisorState.isHealthy() && (this.hasHitUnhealthinessThreshold && this.consecutiveSuccessfulRuns < this.supervisorStateManagerConfig.getHealthinessThreshold() || this.hasHitTaskUnhealthinessThreshold && this.consecutiveSuccessfulTasks < this.supervisorStateManagerConfig.getTaskHealthinessThreshold())) {
            return;
        }
        if (this.healthySteadyState.equals(proposedState) && !this.atLeastOneSuccessfulRun) {
            return;
        }
        if (!proposedState.isFirstRunOnly() || !this.atLeastOneSuccessfulRun) {
            this.supervisorState = proposedState;
        }
    }

    public void recordThrowableEvent(Throwable t) {
        this.recentEventsQueue.add(this.buildExceptionEvent(t));
        if (this.recentEventsQueue.size() > this.supervisorStateManagerConfig.getMaxStoredExceptionEvents()) {
            this.recentEventsQueue.poll();
        }
        this.currentRunSuccessful = false;
    }

    public void recordCompletedTaskState(TaskState state) {
        if (state.isSuccess()) {
            ++this.consecutiveSuccessfulTasks;
            this.consecutiveFailedTasks = 0;
        } else if (state.isFailure()) {
            ++this.consecutiveFailedTasks;
            this.consecutiveSuccessfulTasks = 0;
        }
    }

    public void markRunFinished() {
        this.atLeastOneSuccessfulRun |= this.currentRunSuccessful;
        this.consecutiveSuccessfulRuns = this.currentRunSuccessful ? this.consecutiveSuccessfulRuns + 1 : 0;
        this.consecutiveFailedRuns = this.currentRunSuccessful ? 0 : this.consecutiveFailedRuns + 1;
        this.maybeSetState(this.healthySteadyState);
        this.currentRunSuccessful = true;
    }

    public List<ExceptionEvent> getExceptionEvents() {
        return new ArrayList<ExceptionEvent>(this.recentEventsQueue);
    }

    public State getSupervisorState() {
        return this.supervisorState;
    }

    public boolean isHealthy() {
        return this.supervisorState != null && this.supervisorState.isHealthy();
    }

    public boolean isAtLeastOneSuccessfulRun() {
        return this.atLeastOneSuccessfulRun;
    }

    protected Deque<ExceptionEvent> getRecentEventsQueue() {
        return this.recentEventsQueue;
    }

    protected boolean isStoreStackTrace() {
        return this.supervisorStateManagerConfig.isStoreStackTrace();
    }

    protected State getSpecificUnhealthySupervisorState() {
        return BasicState.UNHEALTHY_SUPERVISOR;
    }

    protected ExceptionEvent buildExceptionEvent(Throwable t) {
        return new ExceptionEvent(t, this.isStoreStackTrace());
    }

    public static class ExceptionEvent {
        private final DateTime timestamp = DateTimes.nowUtc();
        private final String exceptionClass;
        private final String message;

        public ExceptionEvent(Throwable t, boolean storeStackTrace) {
            this.exceptionClass = this.getMeaningfulExceptionClass(t);
            this.message = storeStackTrace ? ExceptionUtils.getStackTrace((Throwable)t) : t.getMessage();
        }

        @JsonProperty
        public DateTime getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty
        public String getExceptionClass() {
            return this.exceptionClass;
        }

        @JsonProperty
        public String getMessage() {
            return this.message;
        }

        protected boolean shouldSkipException(String className) {
            return RuntimeException.class.getName().equals(className);
        }

        private String getMeaningfulExceptionClass(Throwable t) {
            return ExceptionUtils.getThrowableList((Throwable)t).stream().map(x -> x.getClass().getName()).filter(x -> !this.shouldSkipException((String)x)).findFirst().orElse(Exception.class.getName());
        }
    }

    public static enum BasicState implements State
    {
        UNHEALTHY_SUPERVISOR(false, false),
        UNHEALTHY_TASKS(false, false),
        PENDING(true, true),
        RUNNING(true, false),
        SUSPENDED(true, false),
        STOPPING(true, false);

        private final boolean healthy;
        private final boolean firstRunOnly;

        private BasicState(boolean healthy, boolean firstRunOnly) {
            this.healthy = healthy;
            this.firstRunOnly = firstRunOnly;
        }

        @Override
        public boolean isHealthy() {
            return this.healthy;
        }

        @Override
        public boolean isFirstRunOnly() {
            return this.firstRunOnly;
        }
    }

    public static interface State {
        public boolean isHealthy();

        public boolean isFirstRunOnly();

        default public State getBasicState() {
            return this;
        }
    }
}

