/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexer;

import java.util.List;
import org.apache.hive.druid.org.apache.druid.indexer.Property;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;

public final class Checks {
    public static <T> Property<T> checkOneNotNullOrEmpty(List<Property<T>> properties) {
        Property<T> nonNullProperty = null;
        for (Property<T> property : properties) {
            if (property.isValueNullOrEmptyCollection()) continue;
            if (nonNullProperty == null) {
                nonNullProperty = property;
                continue;
            }
            throw new IAE("At most one of %s must be present", properties);
        }
        if (nonNullProperty == null) {
            throw new IAE("At least one of %s must be present", properties);
        }
        return nonNullProperty;
    }

    public static <T> Property<T> checkAtMostOneNotNull(Property<T> property1, Property<T> property2) {
        Property<T> property;
        boolean isNull2;
        boolean isNull1 = property1.getValue() == null;
        boolean bl = isNull2 = property2.getValue() == null;
        if (isNull1 && isNull2) {
            property = property1;
        } else if (isNull1) {
            property = property2;
        } else if (isNull2) {
            property = property1;
        } else {
            throw new IAE("At most one of [%s] or [%s] must be present", property1, property2);
        }
        return property;
    }

    public static <T> Property<T> checkAtMostOneNotNull(String name1, T value1, String name2, T value2) {
        Property<T> property1 = new Property<T>(name1, value1);
        Property<T> property2 = new Property<T>(name2, value2);
        return Checks.checkAtMostOneNotNull(property1, property2);
    }

    private Checks() {
    }
}

