/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigurator;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.SupplierProvider;

public class JsonConfigProvider<T>
implements Provider<Supplier<T>> {
    private final String propertyBase;
    private final Class<T> classToProvide;
    private final Class<? extends T> defaultClass;
    private Properties props;
    private JsonConfigurator configurator;
    private Supplier<T> retVal = null;

    public static <T> void bind(Binder binder, String propertyBase, Class<T> classToProvide) {
        JsonConfigProvider.bind(binder, propertyBase, classToProvide, Key.get(classToProvide), Key.get((Type)Types.newParameterizedType(Supplier.class, (Type[])new Type[]{classToProvide})));
    }

    public static <T> void bindWithDefault(Binder binder, String propertyBase, Class<T> classToProvide, Class<? extends T> defaultClass) {
        JsonConfigProvider.bind(binder, propertyBase, classToProvide, defaultClass, Key.get(classToProvide), Key.get((Type)Types.newParameterizedType(Supplier.class, (Type[])new Type[]{classToProvide})));
    }

    public static <T> void bind(Binder binder, String propertyBase, Class<T> classToProvide, Annotation annotation) {
        JsonConfigProvider.bind(binder, propertyBase, classToProvide, Key.get(classToProvide, (Annotation)annotation), Key.get((Type)Types.newParameterizedType(Supplier.class, (Type[])new Type[]{classToProvide}), (Annotation)annotation));
    }

    public static <T> void bind(Binder binder, String propertyBase, Class<T> classToProvide, Class<? extends Annotation> annotation) {
        JsonConfigProvider.bind(binder, propertyBase, classToProvide, Key.get(classToProvide, annotation), Key.get((Type)Types.newParameterizedType(Supplier.class, (Type[])new Type[]{classToProvide}), annotation));
    }

    public static <T> void bind(Binder binder, String propertyBase, Class<T> clazz, Key<T> instanceKey, Key<Supplier<T>> supplierKey) {
        binder.bind(supplierKey).toProvider(JsonConfigProvider.of(propertyBase, clazz)).in(LazySingleton.class);
        binder.bind(instanceKey).toProvider(new SupplierProvider<T>(supplierKey));
    }

    public static <T> void bind(Binder binder, String propertyBase, Class<T> clazz, Class<? extends T> defaultClass, Key<T> instanceKey, Key<Supplier<T>> supplierKey) {
        binder.bind(supplierKey).toProvider(JsonConfigProvider.of(propertyBase, clazz, defaultClass)).in(LazySingleton.class);
        binder.bind(instanceKey).toProvider(new SupplierProvider<T>(supplierKey));
    }

    public static <T> void bindInstance(Binder binder, Key<T> bindKey, T instance) {
        binder.bind(bindKey).toInstance(instance);
        ParameterizedType supType = Types.newParameterizedType(Supplier.class, (Type[])new Type[]{bindKey.getTypeLiteral().getType()});
        Key supplierKey = bindKey.getAnnotationType() != null ? Key.get((Type)supType, (Class)bindKey.getAnnotationType()) : (bindKey.getAnnotation() != null ? Key.get((Type)supType, (Annotation)bindKey.getAnnotation()) : Key.get((Type)supType));
        binder.bind(supplierKey).toInstance(Suppliers.ofInstance(instance));
    }

    public static <T> JsonConfigProvider<T> of(String propertyBase, Class<T> classToProvide) {
        return JsonConfigProvider.of(propertyBase, classToProvide, null);
    }

    public static <T> JsonConfigProvider<T> of(String propertyBase, Class<T> classToProvide, Class<? extends T> defaultClass) {
        return new JsonConfigProvider<T>(propertyBase, classToProvide, defaultClass);
    }

    public JsonConfigProvider(String propertyBase, Class<T> classToProvide, @Nullable Class<? extends T> defaultClass) {
        this.propertyBase = propertyBase;
        this.classToProvide = classToProvide;
        this.defaultClass = defaultClass;
    }

    @Inject
    public void inject(Properties props, JsonConfigurator configurator) {
        this.props = props;
        this.configurator = configurator;
    }

    public Supplier<T> get() {
        if (this.retVal != null) {
            return this.retVal;
        }
        try {
            T config = this.configurator.configurate(this.props, this.propertyBase, this.classToProvide, this.defaultClass);
            this.retVal = Suppliers.ofInstance(config);
        }
        catch (RuntimeException e) {
            this.retVal = Suppliers.ofInstance(null);
            throw e;
        }
        return this.retVal;
    }
}

