/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BloomFilterAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BloomFilterSerde;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilterHolder;
import org.apache.hive.druid.org.apache.druid.segment.serde.ComplexMetrics;

public class BloomFilterSerializersModule
extends SimpleModule {
    public static final String BLOOM_FILTER_TYPE_NAME = "bloom";

    public BloomFilterSerializersModule() {
        this.registerSubtypes(new NamedType(BloomDimFilter.class, BLOOM_FILTER_TYPE_NAME), new NamedType(BloomFilterAggregatorFactory.class, BLOOM_FILTER_TYPE_NAME));
        this.addSerializer(BloomKFilter.class, new BloomKFilterSerializer());
        this.addDeserializer(BloomKFilter.class, new BloomKFilterDeserializer());
        this.addDeserializer(BloomKFilterHolder.class, new BloomKFilterHolderDeserializer());
        ComplexMetrics.registerSerde(BLOOM_FILTER_TYPE_NAME, new BloomFilterSerde());
    }

    public static byte[] bloomKFilterToBytes(BloomKFilter bloomKFilter) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BloomKFilter.serialize(byteArrayOutputStream, bloomKFilter);
        return byteArrayOutputStream.toByteArray();
    }

    public static BloomKFilter bloomKFilterFromBytes(byte[] bytes) throws IOException {
        return BloomKFilter.deserialize(new ByteArrayInputStream(bytes));
    }

    private static class BloomKFilterHolderDeserializer
    extends StdDeserializer<BloomKFilterHolder> {
        BloomKFilterHolderDeserializer() {
            super(BloomKFilterHolder.class);
        }

        @Override
        public BloomKFilterHolder deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return BloomKFilterHolder.fromBytes(jsonParser.getBinaryValue());
        }
    }

    private static class BloomKFilterDeserializer
    extends StdDeserializer<BloomKFilter> {
        BloomKFilterDeserializer() {
            super(BloomKFilter.class);
        }

        @Override
        public BloomKFilter deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return BloomFilterSerializersModule.bloomKFilterFromBytes(jsonParser.getBinaryValue());
        }
    }

    private static class BloomKFilterSerializer
    extends StdSerializer<BloomKFilter> {
        BloomKFilterSerializer() {
            super(BloomKFilter.class);
        }

        @Override
        public void serialize(BloomKFilter bloomKFilter, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeBinary(BloomFilterSerializersModule.bloomKFilterToBytes(bloomKFilter));
        }
    }
}

