/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.extendedset.intset;

public class ConciseSetUtils {
    public static final int MAX_ALLOWED_INTEGER = 1040187422;
    public static final int MIN_ALLOWED_SET_BIT = 0;
    public static final int MAX_LITERAL_LENGTH = 31;
    public static final int ALL_ONES_LITERAL = -1;
    public static final int ALL_ZEROS_LITERAL = Integer.MIN_VALUE;
    public static final int ALL_ONES_WITHOUT_MSB = Integer.MAX_VALUE;
    public static final int SEQUENCE_BIT = 0x40000000;

    public static int maxLiteralLengthModulus(int n) {
        int m = (n & 0xC1F07C1F) + (n >>> 5 & 0xC1F07C1F);
        if ((m = (m >>> 15) + (m & Short.MAX_VALUE)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        return (m = (m >>> 5) + (m & 0x1F)) == 31 ? 0 : m;
    }

    public static int maxLiteralLengthMultiplication(int n) {
        return n * 31;
    }

    public static int maxLiteralLengthDivision(int n) {
        return n / 31;
    }

    public static boolean isLiteral(int word) {
        return word < 0;
    }

    public static boolean isOneSequence(int word) {
        return (word & 0xC0000000) == 0x40000000;
    }

    public static boolean isZeroSequence(int word) {
        return (word & 0xC0000000) == 0;
    }

    public static boolean isSequenceWithNoBits(int word) {
        return (word & 0xBE000000) == 0;
    }

    public static int getSequenceCount(int word) {
        return word & 0x1FFFFFF;
    }

    public static int getSequenceNumWords(int word) {
        return ConciseSetUtils.getSequenceCount(word) + 1;
    }

    public static int getLiteral(int word, boolean simulateWAH) {
        if (ConciseSetUtils.isLiteral(word)) {
            return word;
        }
        if (simulateWAH) {
            return ConciseSetUtils.isZeroSequence(word) ? Integer.MIN_VALUE : -1;
        }
        int literal = 1 << (word >>> 25) >>> 1;
        return ConciseSetUtils.isZeroSequence(word) ? Integer.MIN_VALUE | literal : 0xFFFFFFFF & ~literal;
    }

    public static int getLiteralFromZeroSeqFlipBit(int word) {
        int flipBit = ConciseSetUtils.getFlippedBit(word);
        if (flipBit > -1) {
            return Integer.MIN_VALUE | ConciseSetUtils.flipBitAsBinaryString(flipBit);
        }
        return Integer.MIN_VALUE;
    }

    public static int getLiteralFromOneSeqFlipBit(int word) {
        int flipBit = ConciseSetUtils.getFlippedBit(word);
        if (flipBit > -1) {
            return 0xFFFFFFFF ^ ConciseSetUtils.flipBitAsBinaryString(flipBit);
        }
        return -1;
    }

    public static int getFlippedBit(int word) {
        return (word >>> 25 & 0x1F) - 1;
    }

    public static int flipBitAsBinaryString(int flipBit) {
        return 1 << flipBit;
    }

    public static int getLiteralBitCount(int word) {
        return Integer.bitCount(ConciseSetUtils.getLiteralBits(word));
    }

    public static int getLiteralBits(int word) {
        return Integer.MAX_VALUE & word;
    }

    public static boolean isAllOnesLiteral(int word) {
        return word == -1;
    }

    public static boolean isAllZerosLiteral(int word) {
        return (word & Integer.MAX_VALUE) == 0;
    }

    public static boolean isLiteralWithSingleZeroBit(int word) {
        return ConciseSetUtils.isLiteral(word) && Integer.bitCount(word) == 31;
    }

    public static boolean isLiteralWithSingleOneBit(int word) {
        return ConciseSetUtils.isLiteral(word) && Integer.bitCount(word) == 2;
    }

    public static int clearBitsAfterInLastWord(int lastWord, int lastSetBit) {
        return lastWord & (Integer.MIN_VALUE | -1 >>> 31 - lastSetBit);
    }

    public static int onesUntil(int bit) {
        return Integer.MIN_VALUE | (1 << bit) - 1;
    }
}

