/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.CacheManager;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.FetchConfig;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.FetchedFile;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.OpenObject;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public abstract class Fetcher<T>
implements Iterator<OpenObject<T>> {
    private static final Logger LOG = new Logger(Fetcher.class);
    private static final String FETCH_FILE_PREFIX = "fetch-";
    private final CacheManager<T> cacheManager;
    private final List<T> objects;
    private final ExecutorService fetchExecutor;
    @Nullable
    private final File temporaryDirectory;
    private final boolean prefetchEnabled;
    private final LinkedBlockingQueue<FetchedFile<T>> fetchedFiles = new LinkedBlockingQueue();
    private final AtomicLong fetchedBytes = new AtomicLong(0L);
    private final Deque<Future<Void>> fetchFutures = new ArrayDeque<Future<Void>>();
    private final FetchConfig fetchConfig;
    private int nextFetchIndex;
    private int numRemainingObjects;

    public Fetcher(CacheManager<T> cacheManager, List<T> objects, ExecutorService fetchExecutor, @Nullable File temporaryDirectory, FetchConfig fetchConfig) {
        this.cacheManager = cacheManager;
        this.objects = objects;
        this.fetchExecutor = fetchExecutor;
        this.temporaryDirectory = temporaryDirectory;
        this.fetchConfig = fetchConfig;
        this.prefetchEnabled = fetchConfig.getMaxFetchCapacityBytes() > 0L;
        this.numRemainingObjects = objects.size();
        this.fetchedFiles.addAll(cacheManager.getFiles());
        this.nextFetchIndex = this.fetchedFiles.size();
        if (cacheManager.isEnabled() || this.prefetchEnabled) {
            Preconditions.checkNotNull(temporaryDirectory, "temporaryDirectory");
        }
        if (this.prefetchEnabled) {
            this.fetchIfNeeded(0L);
        }
    }

    private void fetchIfNeeded(long remainingBytes) {
        if ((this.fetchFutures.isEmpty() || this.fetchFutures.peekLast().isDone()) && remainingBytes <= this.fetchConfig.getPrefetchTriggerBytes()) {
            Future<Void> fetchFuture = this.fetchExecutor.submit(() -> {
                this.fetch();
                return null;
            });
            this.fetchFutures.add(fetchFuture);
        }
    }

    private void fetch() throws Exception {
        while (this.nextFetchIndex < this.objects.size() && this.fetchedBytes.get() <= this.fetchConfig.getMaxFetchCapacityBytes()) {
            T object = this.objects.get(this.nextFetchIndex);
            LOG.info("Fetching [%d]th object[%s], fetchedBytes[%d]", this.nextFetchIndex, object, this.fetchedBytes.get());
            File outFile = File.createTempFile(FETCH_FILE_PREFIX, null, this.temporaryDirectory);
            this.fetchedBytes.addAndGet(this.download(object, outFile));
            this.fetchedFiles.put(new FetchedFile<T>(object, outFile, Fetcher.getFileCloser(outFile, this.fetchedBytes)));
            ++this.nextFetchIndex;
        }
    }

    protected abstract long download(T var1, File var2) throws IOException;

    protected abstract OpenObject<T> generateOpenObject(T var1) throws IOException;

    protected FetchConfig getFetchConfig() {
        return this.fetchConfig;
    }

    @Override
    public boolean hasNext() {
        return this.numRemainingObjects > 0;
    }

    @Override
    public OpenObject<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.checkFetchException(false);
        try {
            OpenObject<T> openObject = this.prefetchEnabled ? this.openObjectFromLocal() : this.openObjectFromRemote();
            --this.numRemainingObjects;
            return openObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkFetchException(boolean wait) {
        try {
            Future<Void> fetchFuture;
            while ((fetchFuture = this.fetchFutures.poll()) != null) {
                if (wait) {
                    fetchFuture.get(this.fetchConfig.getFetchTimeout(), TimeUnit.MILLISECONDS);
                    continue;
                }
                if (fetchFuture.isDone()) {
                    fetchFuture.get();
                    continue;
                }
                this.fetchFutures.addFirst(fetchFuture);
                break;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new ISE(e, "Failed to fetch, but cannot check the reason in [%d] ms", this.fetchConfig.getFetchTimeout());
        }
    }

    private OpenObject<T> openObjectFromLocal() throws IOException {
        FetchedFile<T> fetchedFile;
        if (!this.fetchedFiles.isEmpty()) {
            fetchedFile = this.fetchedFiles.poll();
        } else {
            try {
                this.fetchIfNeeded(this.fetchedBytes.get());
                fetchedFile = this.fetchedFiles.poll(this.fetchConfig.getFetchTimeout(), TimeUnit.MILLISECONDS);
                if (fetchedFile == null) {
                    this.checkFetchException(true);
                    throw new RuntimeException(new TimeoutException());
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        FetchedFile<T> maybeCached = this.cacheIfPossible(fetchedFile);
        this.fetchIfNeeded(this.fetchedBytes.get());
        return new OpenObject<T>(maybeCached);
    }

    private OpenObject<T> openObjectFromRemote() throws IOException {
        if (this.fetchedFiles.size() > 0) {
            return new OpenObject<T>(this.fetchedFiles.poll());
        }
        if (this.cacheManager.cacheable()) {
            try {
                this.fetch();
                FetchedFile<T> fetchedFile = this.fetchedFiles.poll();
                if (fetchedFile == null) {
                    throw new ISE("Cannot fetch object[%s]", this.objects.get(this.nextFetchIndex - 1));
                }
                FetchedFile<T> cached = this.cacheIfPossible(fetchedFile);
                return new OpenObject<T>(cached);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        T object = this.objects.get(this.nextFetchIndex);
        LOG.info("Reading [%d]th object[%s]", this.nextFetchIndex, object);
        ++this.nextFetchIndex;
        return this.generateOpenObject(object);
    }

    private FetchedFile<T> cacheIfPossible(FetchedFile<T> fetchedFile) {
        if (this.cacheManager.cacheable()) {
            FetchedFile<T> cachedFile = this.cacheManager.cache(fetchedFile);
            this.fetchedBytes.addAndGet(-fetchedFile.length());
            return cachedFile;
        }
        return fetchedFile;
    }

    private static Closeable getFileCloser(File file, AtomicLong fetchedBytes) {
        return () -> {
            long fileSize = file.length();
            file.delete();
            fetchedBytes.addAndGet(-fileSize);
        };
    }
}

