/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.TextReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;

public class JsonReader
extends TextReader {
    private final ObjectFlattener<JsonNode> flattener;
    private final ObjectMapper mapper;

    JsonReader(InputRowSchema inputRowSchema, InputEntity source, JSONPathSpec flattenSpec, ObjectMapper mapper) {
        super(inputRowSchema, source);
        this.flattener = ObjectFlatteners.create(flattenSpec, new JSONFlattenerMaker());
        this.mapper = mapper;
    }

    @Override
    public List<InputRow> parseInputRows(String line) throws IOException, ParseException {
        JsonNode document = this.mapper.readValue(line, JsonNode.class);
        Map<String, Object> flattened = this.flattener.flatten(document);
        return Collections.singletonList(MapInputRowParser.parse(this.getInputRowSchema(), flattened));
    }

    @Override
    public Map<String, Object> toMap(String intermediateRow) throws IOException {
        return this.mapper.readValue(intermediateRow, Map.class);
    }

    @Override
    public int getNumHeaderLinesToSkip() {
        return 0;
    }

    @Override
    public boolean needsToProcessHeaderLine() {
        return false;
    }

    @Override
    public void processHeaderLine(String line) {
    }
}

