/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntityReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.JsonReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.NestedInputFormat;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathSpec;

public class JsonInputFormat
extends NestedInputFormat {
    private final Map<String, Boolean> featureSpec;
    private final ObjectMapper objectMapper;

    @JsonCreator
    public JsonInputFormat(@JsonProperty(value="flattenSpec") @Nullable JSONPathSpec flattenSpec, @JsonProperty(value="featureSpec") @Nullable Map<String, Boolean> featureSpec) {
        super(flattenSpec);
        this.featureSpec = featureSpec == null ? Collections.emptyMap() : featureSpec;
        this.objectMapper = new ObjectMapper();
        for (Map.Entry<String, Boolean> entry : this.featureSpec.entrySet()) {
            JsonParser.Feature feature = JsonParser.Feature.valueOf(entry.getKey());
            this.objectMapper.configure(feature, (boolean)entry.getValue());
        }
    }

    @JsonProperty
    public Map<String, Boolean> getFeatureSpec() {
        return this.featureSpec;
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new JsonReader(inputRowSchema, source, this.getFlattenSpec(), this.objectMapper);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonInputFormat that = (JsonInputFormat)o;
        return Objects.equals(this.featureSpec, that.featureSpec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.featureSpec);
    }
}

