/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.hive.druid.org.apache.druid.data.input.InputSourceReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;

public class FirehoseToInputSourceReaderAdaptor
implements InputSourceReader {
    private final FirehoseFactory firehoseFactory;
    private final InputRowParser inputRowParser;
    private final File temporaryDirectory;

    public FirehoseToInputSourceReaderAdaptor(FirehoseFactory firehoseFactory, InputRowParser inputRowParser, File temporaryDirectory) {
        this.firehoseFactory = firehoseFactory;
        this.inputRowParser = inputRowParser;
        this.temporaryDirectory = temporaryDirectory;
    }

    @Override
    public CloseableIterator<InputRow> read() throws IOException {
        return new CloseableIterator<InputRow>(){
            final Firehose firehose;
            {
                this.firehose = FirehoseToInputSourceReaderAdaptor.this.firehoseFactory.connect(FirehoseToInputSourceReaderAdaptor.this.inputRowParser, FirehoseToInputSourceReaderAdaptor.this.temporaryDirectory);
            }

            @Override
            public boolean hasNext() {
                try {
                    return this.firehose.hasMore();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public InputRow next() {
                try {
                    return this.firehose.nextRow();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                this.firehose.close();
            }
        };
    }

    @Override
    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        return new CloseableIterator<InputRowListPlusRawValues>(){
            final Firehose firehose;
            {
                this.firehose = FirehoseToInputSourceReaderAdaptor.this.firehoseFactory.connectForSampler(FirehoseToInputSourceReaderAdaptor.this.inputRowParser, FirehoseToInputSourceReaderAdaptor.this.temporaryDirectory);
            }

            @Override
            public boolean hasNext() {
                try {
                    return this.firehose.hasMore();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public InputRowListPlusRawValues next() {
                try {
                    return this.firehose.nextRowWithRaw();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                this.firehose.close();
            }
        };
    }
}

