/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParserUtils;

public class DimensionsSpec {
    private final List<DimensionSchema> dimensions;
    private final Set<String> dimensionExclusions;
    private final Map<String, DimensionSchema> dimensionSchemaMap;
    public static final DimensionsSpec EMPTY = new DimensionsSpec(null, null, null);

    public static List<DimensionSchema> getDefaultSchemas(List<String> dimNames) {
        return DimensionsSpec.getDefaultSchemas(dimNames, DimensionSchema.MultiValueHandling.ofDefault());
    }

    public static List<DimensionSchema> getDefaultSchemas(List<String> dimNames, DimensionSchema.MultiValueHandling multiValueHandling) {
        return dimNames.stream().map(input -> new StringDimensionSchema((String)input, multiValueHandling, (Boolean)true)).collect(Collectors.toList());
    }

    public static DimensionSchema convertSpatialSchema(SpatialDimensionSchema spatialSchema) {
        return new NewSpatialDimensionSchema(spatialSchema.getDimName(), spatialSchema.getDims());
    }

    @JsonCreator
    public DimensionsSpec(@JsonProperty(value="dimensions") List<DimensionSchema> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions, @Deprecated @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions) {
        HashSet<String> hashSet;
        List<DimensionSchema> list;
        if (dimensions == null) {
            ArrayList<DimensionSchema> arrayList;
            list = arrayList;
        } else {
            list = this.dimensions = Lists.newArrayList(dimensions);
        }
        if (dimensionExclusions == null) {
            HashSet<String> hashSet2;
            hashSet = hashSet2;
            super();
        } else {
            hashSet = Sets.newHashSet(dimensionExclusions);
        }
        this.dimensionExclusions = hashSet;
        ArrayList<SpatialDimensionSchema> spatialDims = spatialDimensions == null ? new ArrayList<SpatialDimensionSchema>() : spatialDimensions;
        this.verify(spatialDims);
        this.dimensionSchemaMap = new HashMap<String, DimensionSchema>();
        for (DimensionSchema schema : this.dimensions) {
            this.dimensionSchemaMap.put(schema.getName(), schema);
        }
        for (SpatialDimensionSchema spatialSchema : spatialDims) {
            DimensionSchema newSchema = DimensionsSpec.convertSpatialSchema(spatialSchema);
            this.dimensions.add(newSchema);
            this.dimensionSchemaMap.put(newSchema.getName(), newSchema);
        }
    }

    public DimensionsSpec(List<DimensionSchema> dimensions) {
        this(dimensions, null, null);
    }

    @JsonProperty
    public List<DimensionSchema> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public Set<String> getDimensionExclusions() {
        return this.dimensionExclusions;
    }

    @Deprecated
    @JsonIgnore
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        Iterable<NewSpatialDimensionSchema> filteredList = Iterables.filter(this.dimensions, NewSpatialDimensionSchema.class);
        Iterable<SpatialDimensionSchema> transformedList = Iterables.transform(filteredList, new Function<NewSpatialDimensionSchema, SpatialDimensionSchema>(){

            @Override
            @Nullable
            public SpatialDimensionSchema apply(NewSpatialDimensionSchema input) {
                return new SpatialDimensionSchema(input.getName(), input.getDims());
            }
        });
        return Lists.newArrayList(transformedList);
    }

    @JsonIgnore
    public List<String> getDimensionNames() {
        return Lists.transform(this.dimensions, new Function<DimensionSchema, String>(){

            @Override
            public String apply(DimensionSchema input) {
                return input.getName();
            }
        });
    }

    public DimensionSchema getSchema(String dimension) {
        return this.dimensionSchemaMap.get(dimension);
    }

    public boolean hasCustomDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public DimensionsSpec withDimensions(List<DimensionSchema> dims) {
        return new DimensionsSpec(dims, ImmutableList.copyOf(this.dimensionExclusions), null);
    }

    public DimensionsSpec withDimensionExclusions(Set<String> dimExs) {
        return new DimensionsSpec(this.dimensions, ImmutableList.copyOf(Sets.union(this.dimensionExclusions, dimExs)), null);
    }

    @Deprecated
    public DimensionsSpec withSpatialDimensions(List<SpatialDimensionSchema> spatials) {
        return new DimensionsSpec(this.dimensions, ImmutableList.copyOf(this.dimensionExclusions), spatials);
    }

    private void verify(List<SpatialDimensionSchema> spatialDimensions) {
        List<String> dimNames = this.getDimensionNames();
        Preconditions.checkArgument(Sets.intersection(this.dimensionExclusions, Sets.newHashSet(dimNames)).isEmpty(), "dimensions and dimensions exclusions cannot overlap");
        List<String> spatialDimNames = Lists.transform(spatialDimensions, new Function<SpatialDimensionSchema, String>(){

            @Override
            public String apply(SpatialDimensionSchema input) {
                return input.getDimName();
            }
        });
        ParserUtils.validateFields(Iterables.concat(dimNames, spatialDimNames));
        ParserUtils.validateFields(this.dimensionExclusions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionsSpec that = (DimensionsSpec)o;
        if (!this.dimensions.equals(that.dimensions)) {
            return false;
        }
        return this.dimensionExclusions.equals(that.dimensionExclusions);
    }

    public int hashCode() {
        int result = this.dimensions.hashCode();
        result = 31 * result + this.dimensionExclusions.hashCode();
        return result;
    }

    public String toString() {
        return "DimensionsSpec{dimensions=" + this.dimensions + ", dimensionExclusions=" + this.dimensionExclusions + '}';
    }
}

