/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParserUtils;

public abstract class TextReader
extends IntermediateRowParsingReader<String> {
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;

    public TextReader(InputRowSchema inputRowSchema, InputEntity source) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
    }

    public InputRowSchema getInputRowSchema() {
        return this.inputRowSchema;
    }

    @Override
    public CloseableIterator<String> intermediateRowIterator() throws IOException {
        final LineIterator delegate = new LineIterator((Reader)new InputStreamReader(this.source.open(), StringUtils.UTF8_STRING));
        int numHeaderLines = this.getNumHeaderLinesToSkip();
        for (int i = 0; i < numHeaderLines && delegate.hasNext(); ++i) {
            delegate.nextLine();
        }
        if (this.needsToProcessHeaderLine() && delegate.hasNext()) {
            this.processHeaderLine(delegate.nextLine());
        }
        return new CloseableIterator<String>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public String next() {
                return delegate.nextLine();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public abstract List<InputRow> parseInputRows(String var1) throws IOException, ParseException;

    public abstract int getNumHeaderLinesToSkip();

    public abstract boolean needsToProcessHeaderLine();

    public abstract void processHeaderLine(String var1) throws IOException;

    public static List<String> findOrCreateColumnNames(List<String> parsedLine) {
        ArrayList<String> columns = new ArrayList<String>(parsedLine.size());
        for (int i = 0; i < parsedLine.size(); ++i) {
            if (Strings.isNullOrEmpty(parsedLine.get(i))) {
                columns.add(ParserUtils.getDefaultColumnName(i));
                continue;
            }
            columns.add(parsedLine.get(i));
        }
        if (columns.isEmpty()) {
            return ParserUtils.generateFieldNames(parsedLine.size());
        }
        ParserUtils.validateFields(columns);
        return columns;
    }
}

