/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.AbstractInputSource;
import org.apache.hive.druid.org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.InputSourceReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.SplitHintSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FirehoseToInputSourceReaderAdaptor;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.SplittableInputSource;

public class FirehoseFactoryToInputSourceAdaptor
extends AbstractInputSource
implements SplittableInputSource {
    private final FiniteFirehoseFactory firehoseFactory;
    private final InputRowParser inputRowParser;

    public FirehoseFactoryToInputSourceAdaptor(FiniteFirehoseFactory firehoseFactory, InputRowParser inputRowParser) {
        this.firehoseFactory = firehoseFactory;
        this.inputRowParser = Preconditions.checkNotNull(inputRowParser, "inputRowParser");
    }

    public FiniteFirehoseFactory getFirehoseFactory() {
        return this.firehoseFactory;
    }

    public InputRowParser getInputRowParser() {
        return this.inputRowParser;
    }

    @Override
    public boolean isSplittable() {
        return this.firehoseFactory.isSplittable();
    }

    public Stream<InputSplit> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        if (this.firehoseFactory.isSplittable()) {
            return this.firehoseFactory.getSplits(splitHintSpec);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        if (this.firehoseFactory.isSplittable()) {
            return this.firehoseFactory.getNumSplits(splitHintSpec);
        }
        throw new UnsupportedOperationException();
    }

    public SplittableInputSource withSplit(InputSplit split) {
        if (this.firehoseFactory.isSplittable()) {
            return new FirehoseFactoryToInputSourceAdaptor(this.firehoseFactory.withSplit(split), this.inputRowParser);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsFormat() {
        return false;
    }

    @Override
    protected InputSourceReader fixedFormatReader(InputRowSchema inputRowSchema, @Nullable File temporaryDirectory) {
        return new FirehoseToInputSourceReaderAdaptor(this.firehoseFactory, this.inputRowParser, temporaryDirectory);
    }
}

