/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator;

import javax.validation.constraints.Min;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.hive.druid.org.apache.druid.metadata.PasswordProvider;

public class CuratorConfig {
    static final String HOST = "host";
    @JsonProperty(value="host")
    private String zkHosts = "localhost";
    @JsonProperty(value="sessionTimeoutMs")
    @Min(value=0L)
    private int zkSessionTimeoutMs = 30000;
    static final String CONNECTION_TIMEOUT_MS = "connectionTimeoutMs";
    @JsonProperty(value="connectionTimeoutMs")
    @Min(value=0L)
    private int zkConnectionTimeoutMs = 15000;
    @JsonProperty(value="compress")
    private boolean enableCompression = true;
    @JsonProperty(value="acl")
    private boolean enableAcl = false;
    @JsonProperty(value="user")
    private String zkUser;
    @JsonProperty(value="pwd")
    private PasswordProvider zkPwd = new DefaultPasswordProvider("");
    @JsonProperty(value="authScheme")
    private String authScheme = "digest";

    public String getZkHosts() {
        return this.zkHosts;
    }

    public void setZkHosts(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    public int getZkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void setZkSessionTimeoutMs(Integer zkSessionTimeoutMs) {
        this.zkSessionTimeoutMs = zkSessionTimeoutMs;
    }

    public int getZkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }

    public void setZkConnectionTimeoutMs(Integer zkConnectionTimeoutMs) {
        this.zkConnectionTimeoutMs = zkConnectionTimeoutMs;
    }

    public boolean getEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(Boolean enableCompression) {
        Preconditions.checkNotNull(enableCompression, "enableCompression");
        this.enableCompression = enableCompression;
    }

    public boolean getEnableAcl() {
        return this.enableAcl;
    }

    public void setEnableAcl(Boolean enableAcl) {
        Preconditions.checkNotNull(enableAcl, "enableAcl");
        this.enableAcl = enableAcl;
    }

    public String getZkUser() {
        return this.zkUser;
    }

    public String getZkPwd() {
        return this.zkPwd.getPassword();
    }

    public String getAuthScheme() {
        return this.authScheme;
    }
}

