/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.org.apache.druid.io.Channels;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;

public class SerializerUtils {
    public <T extends OutputStream> void writeString(T out, String name) throws IOException {
        byte[] nameBytes = StringUtils.toUtf8(name);
        this.writeInt(out, nameBytes.length);
        out.write(nameBytes);
    }

    public void writeString(WritableByteChannel out, String name) throws IOException {
        byte[] nameBytes = StringUtils.toUtf8(name);
        SerializerUtils.writeInt(out, nameBytes.length);
        Channels.writeFully(out, ByteBuffer.wrap(nameBytes));
    }

    String readString(InputStream in) throws IOException {
        int length = this.readInt(in);
        byte[] stringBytes = new byte[length];
        ByteStreams.readFully(in, stringBytes);
        return StringUtils.fromUtf8(stringBytes);
    }

    public String readString(ByteBuffer in) {
        int length = in.getInt();
        return StringUtils.fromUtf8(this.readBytes(in, length));
    }

    public byte[] readBytes(ByteBuffer in, int length) {
        byte[] bytes = new byte[length];
        in.get(bytes);
        return bytes;
    }

    String[] readStrings(InputStream in) throws IOException {
        int length = this.readInt(in);
        String[] retVal = new String[length];
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.readString(in);
        }
        return retVal;
    }

    String[] readStrings(ByteBuffer in) {
        int length = in.getInt();
        String[] retVal = new String[length];
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.readString(in);
        }
        return retVal;
    }

    private void writeInt(OutputStream out, int intValue) throws IOException {
        out.write(Ints.toByteArray(intValue));
    }

    public static void writeInt(WritableByteChannel out, int intValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(intValue);
        buffer.flip();
        Channels.writeFully(out, buffer);
    }

    private int readInt(InputStream in) throws IOException {
        byte[] intBytes = new byte[4];
        ByteStreams.readFully(in, intBytes);
        return Ints.fromByteArray(intBytes);
    }

    void writeInts(OutputStream out, int[] ints) throws IOException {
        this.writeInt(out, ints.length);
        for (int value : ints) {
            this.writeInt(out, value);
        }
    }

    int[] readInts(InputStream in) throws IOException {
        int size = this.readInt(in);
        int[] retVal = new int[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = this.readInt(in);
        }
        return retVal;
    }

    private void writeLong(OutputStream out, long longValue) throws IOException {
        out.write(Longs.toByteArray(longValue));
    }

    public void writeLong(WritableByteChannel out, long longValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(longValue);
        buffer.flip();
        Channels.writeFully(out, buffer);
    }

    long readLong(InputStream in) throws IOException {
        byte[] longBytes = new byte[8];
        ByteStreams.readFully(in, longBytes);
        return Longs.fromByteArray(longBytes);
    }

    void writeLongs(OutputStream out, long[] longs) throws IOException {
        this.writeInt(out, longs.length);
        for (long value : longs) {
            this.writeLong(out, value);
        }
    }

    long[] readLongs(InputStream in) throws IOException {
        int size = this.readInt(in);
        long[] retVal = new long[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = this.readLong(in);
        }
        return retVal;
    }

    public void writeFloat(OutputStream out, float floatValue) throws IOException {
        this.writeInt(out, Float.floatToRawIntBits(floatValue));
    }

    void writeFloat(WritableByteChannel out, float floatValue) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(floatValue);
        buffer.flip();
        Channels.writeFully(out, buffer);
    }

    float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(this.readInt(in));
    }

    void writeFloats(OutputStream out, float[] floats) throws IOException {
        this.writeInt(out, floats.length);
        for (float value : floats) {
            this.writeFloat(out, value);
        }
    }

    float[] readFloats(InputStream in) throws IOException {
        int size = this.readInt(in);
        float[] retVal = new float[size];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = this.readFloat(in);
        }
        return retVal;
    }

    public int getSerializedStringByteSize(String str) {
        return 4 + StringUtils.toUtf8(str).length;
    }
}

