/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.common.config;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;

public class Log4jShutdown
implements ShutdownCallbackRegistry,
LifeCycle {
    private static final long SHUTDOWN_WAIT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private final SynchronizedStateHolder state = new SynchronizedStateHolder(LifeCycle.State.INITIALIZED);
    private final Queue<Runnable> shutdownCallbacks = new ConcurrentLinkedQueue<Runnable>();

    public Cancellable addShutdownCallback(final Runnable callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        Cancellable cancellable = new Cancellable(){
            private volatile boolean cancelled = false;
            private final AtomicBoolean ran = new AtomicBoolean(false);

            public void cancel() {
                this.cancelled = true;
            }

            public void run() {
                if (!this.cancelled && this.ran.compareAndSet(false, true)) {
                    callback.run();
                }
            }
        };
        this.shutdownCallbacks.add((Runnable)cancellable);
        if (!this.isStarted()) {
            callback.run();
            throw new IllegalStateException("Shutting down while adding shutdown hook. Callback fired just in case");
        }
        return cancellable;
    }

    public LifeCycle.State getState() {
        return this.state.get();
    }

    public void initialize() {
    }

    public void start() {
        if (!this.state.compareAndSet(LifeCycle.State.INITIALIZED, LifeCycle.State.STARTED)) {
            throw new ISE("Expected state [%s] found [%s]", LifeCycle.State.INITIALIZED, this.state.get());
        }
    }

    public void stop() {
        if (!this.state.compareAndSet(LifeCycle.State.STARTED, LifeCycle.State.STOPPING)) {
            LifeCycle.State current = this.state.waitForTransition(LifeCycle.State.STOPPING, LifeCycle.State.STOPPED, Log4jShutdown.SHUTDOWN_WAIT_TIMEOUT_MILLIS);
            if (current != LifeCycle.State.STOPPED) {
                throw new ISE("Expected state [%s] found [%s]", LifeCycle.State.STARTED, current);
            }
            return;
        }
        try {
            this.runCallbacks();
        }
        finally {
            this.state.compareAndSet(LifeCycle.State.STOPPING, LifeCycle.State.STOPPED);
        }
    }

    private void runCallbacks() {
        Throwable e = null;
        Runnable callback = this.shutdownCallbacks.poll();
        while (callback != null) {
            try {
                callback.run();
            }
            catch (RuntimeException ex) {
                if (e == null) {
                    e = new RuntimeException("Error running callback");
                }
                e.addSuppressed(ex);
            }
            callback = this.shutdownCallbacks.poll();
        }
        if (e != null) {
            throw e;
        }
    }

    public boolean isStarted() {
        return LifeCycle.State.STARTED.equals((Object)this.getState());
    }

    public boolean isStopped() {
        return LifeCycle.State.STOPPED.equals((Object)this.getState());
    }

    private static class SynchronizedStateHolder {
        @GuardedBy(value="this")
        private LifeCycle.State current;

        private SynchronizedStateHolder(LifeCycle.State initial) {
            this.current = initial;
        }

        private synchronized boolean compareAndSet(LifeCycle.State expected, LifeCycle.State transition) {
            if (this.current == expected) {
                this.current = transition;
                this.notifyAll();
                return true;
            }
            return false;
        }

        private synchronized LifeCycle.State waitForTransition(LifeCycle.State expected, LifeCycle.State transition, long timeout) {
            if (this.current == expected) {
                try {
                    long now;
                    long prev = System.currentTimeMillis();
                    for (long remaining = timeout; this.current != transition && remaining > 0L; remaining -= now - prev) {
                        this.wait(remaining);
                        now = System.currentTimeMillis();
                        prev = now;
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.current;
        }

        private synchronized LifeCycle.State get() {
            return this.current;
        }
    }
}

