/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.spatial.search;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.collections.spatial.ImmutableNode;
import org.apache.hive.druid.org.apache.druid.collections.spatial.ImmutablePoint;
import org.apache.hive.druid.org.apache.druid.collections.spatial.search.Bound;

public class RectangularBound
implements Bound {
    private static final byte CACHE_TYPE_ID = 0;
    private final float[] minCoords;
    private final float[] maxCoords;
    private final int limit;
    private final int numDims;

    @JsonCreator
    public RectangularBound(@JsonProperty(value="minCoords") float[] minCoords, @JsonProperty(value="maxCoords") float[] maxCoords, @JsonProperty(value="limit") int limit) {
        Preconditions.checkArgument(minCoords.length == maxCoords.length);
        this.numDims = minCoords.length;
        this.minCoords = minCoords;
        this.maxCoords = maxCoords;
        this.limit = limit;
    }

    public RectangularBound(float[] minCoords, float[] maxCoords) {
        this(minCoords, maxCoords, 0);
    }

    @JsonProperty
    public float[] getMinCoords() {
        return this.minCoords;
    }

    @JsonProperty
    public float[] getMaxCoords() {
        return this.maxCoords;
    }

    @Override
    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getNumDims() {
        return this.numDims;
    }

    @Override
    public boolean overlaps(ImmutableNode node) {
        float[] nodeMinCoords = node.getMinCoordinates();
        float[] nodeMaxCoords = node.getMaxCoordinates();
        for (int i = 0; i < this.numDims; ++i) {
            if (!(nodeMaxCoords[i] < this.minCoords[i]) && !(nodeMinCoords[i] > this.maxCoords[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(float[] coords) {
        for (int i = 0; i < this.numDims; ++i) {
            if (!(coords[i] < this.minCoords[i]) && !(coords[i] > this.maxCoords[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<ImmutablePoint> filter(Iterable<ImmutablePoint> points) {
        return Iterables.filter(points, new Predicate<ImmutablePoint>(){

            @Override
            public boolean apply(ImmutablePoint immutablePoint) {
                return RectangularBound.this.contains(immutablePoint.getCoords());
            }
        });
    }

    @Override
    public byte[] getCacheKey() {
        ByteBuffer minCoordsBuffer = ByteBuffer.allocate(this.minCoords.length * 4);
        minCoordsBuffer.asFloatBuffer().put(this.minCoords);
        byte[] minCoordsCacheKey = minCoordsBuffer.array();
        ByteBuffer maxCoordsBuffer = ByteBuffer.allocate(this.maxCoords.length * 4);
        maxCoordsBuffer.asFloatBuffer().put(this.maxCoords);
        byte[] maxCoordsCacheKey = maxCoordsBuffer.array();
        ByteBuffer cacheKey = ByteBuffer.allocate(1 + minCoordsCacheKey.length + maxCoordsCacheKey.length + 4).put(minCoordsCacheKey).put(maxCoordsCacheKey).putInt(this.limit).put((byte)0);
        return cacheKey.array();
    }
}

