/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.roaringbitmap.RoaringBitmap;
import org.apache.hive.druid.org.roaringbitmap.buffer.BufferFastAggregation;
import org.apache.hive.druid.org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class RoaringBitmapFactory
implements BitmapFactory {
    static final boolean DEFAULT_COMPRESS_RUN_ON_SERIALIZATION = false;
    private static final ImmutableRoaringBitmap EMPTY_IMMUTABLE_BITMAP;
    private static final WrappedImmutableRoaringBitmap WRAPPED_IMMUTABLE_ROARING_BITMAP;
    private final boolean compressRunOnSerialization;

    public RoaringBitmapFactory() {
        this(false);
    }

    public RoaringBitmapFactory(boolean compressRunOnSerialization) {
        this.compressRunOnSerialization = compressRunOnSerialization;
    }

    private static Iterable<ImmutableRoaringBitmap> unwrap(final Iterable<ImmutableBitmap> b) {
        return new Iterable<ImmutableRoaringBitmap>(){

            @Override
            public Iterator<ImmutableRoaringBitmap> iterator() {
                final Iterator i = b.iterator();
                return new Iterator<ImmutableRoaringBitmap>(){

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public ImmutableRoaringBitmap next() {
                        WrappedImmutableRoaringBitmap wrappedBitmap = (WrappedImmutableRoaringBitmap)i.next();
                        if (wrappedBitmap == null) {
                            return EMPTY_IMMUTABLE_BITMAP;
                        }
                        return wrappedBitmap.getBitmap();
                    }
                };
            }
        };
    }

    @Override
    public MutableBitmap makeEmptyMutableBitmap() {
        return new WrappedRoaringBitmap(this.compressRunOnSerialization);
    }

    @Override
    public ImmutableBitmap makeEmptyImmutableBitmap() {
        return WRAPPED_IMMUTABLE_ROARING_BITMAP;
    }

    @Override
    public ImmutableBitmap makeImmutableBitmap(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedRoaringBitmap)) {
            throw new ISE("Cannot convert [%s]", mutableBitmap.getClass());
        }
        try {
            return ((WrappedRoaringBitmap)mutableBitmap).toImmutableBitmap();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableBitmap mapImmutableBitmap(ByteBuffer b) {
        return new WrappedImmutableRoaringBitmap(b);
    }

    @Override
    public ImmutableBitmap union(Iterable<ImmutableBitmap> b) {
        if (b instanceof Collection) {
            Collection bitmapList = (Collection)b;
            int size = bitmapList.size();
            if (size == 0) {
                return this.makeEmptyImmutableBitmap();
            }
            if (size == 1) {
                return Iterables.getOnlyElement(b);
            }
        }
        return new WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap.or(RoaringBitmapFactory.unwrap(b).iterator()));
    }

    @Override
    public ImmutableBitmap intersection(Iterable<ImmutableBitmap> b) {
        return new WrappedImmutableRoaringBitmap(BufferFastAggregation.and(RoaringBitmapFactory.unwrap(b).iterator()));
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b, int length) {
        return new WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap.flip(((WrappedImmutableRoaringBitmap)b).getBitmap(), 0, length));
    }

    static {
        try {
            RoaringBitmap roaringBitmap = new RoaringBitmap();
            ByteBuffer buffer = ByteBuffer.allocate(roaringBitmap.serializedSizeInBytes());
            roaringBitmap.serialize(buffer);
            buffer.flip();
            EMPTY_IMMUTABLE_BITMAP = new ImmutableRoaringBitmap(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        WRAPPED_IMMUTABLE_ROARING_BITMAP = new WrappedImmutableRoaringBitmap(EMPTY_IMMUTABLE_BITMAP);
    }
}

