/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;

public class SerializablePair<T1, T2>
extends Pair<T1, T2> {
    @JsonCreator
    public SerializablePair(@JsonProperty(value="lhs") T1 lhs, @JsonProperty(value="rhs") @Nullable T2 rhs) {
        super(lhs, rhs);
    }

    @JsonProperty
    public T1 getLhs() {
        return (T1)this.lhs;
    }

    @JsonProperty
    @Nullable
    public T2 getRhs() {
        return (T2)this.rhs;
    }

    public static <T1, T2> Comparator<SerializablePair<T1, T2>> createNullHandlingComparator(Comparator<T2> delegate, boolean nullsFirst) {
        int firstIsNull = nullsFirst ? -1 : 1;
        int secondIsNull = nullsFirst ? 1 : -1;
        return (o1, o2) -> {
            if (o1 == null || o1.rhs == null) {
                if (o2 == null || o2.rhs == null) {
                    return 0;
                }
                return firstIsNull;
            }
            if (o2 == null || o2.rhs == null) {
                return secondIsNull;
            }
            return delegate.compare(o1.rhs, o2.rhs);
        };
    }
}

