/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BinaryOperator;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.PeekingIterator;

public class CombiningIterator<T>
implements Iterator<T> {
    private final PeekingIterator<T> it;
    private final Comparator<T> comparator;
    private final BinaryOperator<T> fn;

    public static <T> CombiningIterator<T> create(Iterator<T> it, Comparator<T> comparator, BinaryOperator<T> fn) {
        return new CombiningIterator<T>(it, comparator, fn);
    }

    public CombiningIterator(Iterator<T> it, Comparator<T> comparator, BinaryOperator<T> fn) {
        this.it = Iterators.peekingIterator(it);
        this.comparator = comparator;
        this.fn = fn;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object res = null;
        while (this.hasNext()) {
            if (res == null) {
                res = this.fn.apply(this.it.next(), null);
                continue;
            }
            if (this.comparator.compare(res, this.it.peek()) != 0) break;
            res = this.fn.apply(res, this.it.next());
        }
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

