/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BinaryOperator;
import org.apache.hive.druid.org.apache.druid.collections.CombiningIterator;
import org.apache.hive.druid.org.apache.druid.common.guava.GuavaUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.MergeIterable;

public class CombiningIterable<T>
implements Iterable<T> {
    private final Iterable<T> it;
    private final Comparator<T> comparator;
    private final BinaryOperator<T> fn;

    public static <T> CombiningIterable<T> createSplatted(Iterable<? extends Iterable<T>> in, Comparator<T> comparator) {
        return CombiningIterable.create(new MergeIterable<T>(comparator, in), comparator, GuavaUtils::firstNonNull);
    }

    public static <T> CombiningIterable<T> create(Iterable<T> it, Comparator<T> comparator, BinaryOperator<T> fn) {
        return new CombiningIterable<T>(it, comparator, fn);
    }

    public CombiningIterable(Iterable<T> it, Comparator<T> comparator, BinaryOperator<T> fn) {
        this.it = it;
        this.comparator = comparator;
        this.fn = fn;
    }

    @Override
    public Iterator<T> iterator() {
        return CombiningIterator.create(this.it.iterator(), this.comparator, this.fn);
    }
}

